<?php
require_once '../config/config.php';
require_once '../config/database.php';

// Inicia a sessão se ainda não foi iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Verifica se é uma requisição POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    $_SESSION['login_error'] = 'Método inválido';
    header('Location: ../index.php');
    exit;
}

// Pega os dados do formulário
$nome = trim($_POST['nome'] ?? '');
$senha = $_POST['senha'] ?? '';

// Valida os campos
if (empty($nome) || empty($senha)) {
    $_SESSION['login_error'] = 'Preencha todos os campos';
    header('Location: ../index.php');
    exit;
}

try {
    // Conecta ao banco
    $database = new Database();
    $db = $database->getConnection();

    // Busca o usuário
    $query = "SELECT id, nome, senha, tipo FROM usuarios WHERE nome = :nome LIMIT 1";
    $stmt = $db->prepare($query);
    $stmt->bindParam(':nome', $nome);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        $usuario = $stmt->fetch(PDO::FETCH_ASSOC);

        // Verifica a senha
        if (password_verify($senha, $usuario['senha'])) {
            // Login bem sucedido
            $_SESSION['user_id'] = $usuario['id'];
            $_SESSION['user_name'] = $usuario['nome'];
            $_SESSION['user_type'] = $usuario['tipo'];

            // Redireciona baseado no tipo de usuário
            if ($usuario['tipo'] == 'admin') {
                header('Location: ../pages/admin/dashboard.php');
            } else {
                header('Location: ../pages/medico/dashboard.php');
            }
            exit;
        } else {
            $_SESSION['login_error'] = 'Senha incorreta';
        }
    } else {
        $_SESSION['login_error'] = 'Usuário não encontrado';
    }
} catch (PDOException $e) {
    error_log($e->getMessage());
    $_SESSION['login_error'] = 'Erro ao fazer login. Tente novamente.';
}

// Se chegou até aqui, houve erro
header('Location: ../index.php');
exit;
?> 