<?php
require_once '../../config/config.php';
session_start();
require_once '../../includes/auth.php';
requireMedico(); // Verifica se é médico
require_once '../../includes/header.php';
?>

<div class="container-fluid">
    <div class="row">
        <!-- Sidebar -->
        <?php require_once '../../includes/sidebar.php'; ?>

        <!-- Conteúdo Principal -->
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Dashboard Médico</h1>
            </div>

            <!-- Estatísticas -->
            <div class="row">
                <div class="col-md-4 mb-4">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Pacientes na Fila</h5>
                            <p class="card-text display-4" id="pacientesNaFila">0</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Atendimentos Hoje</h5>
                            <p class="card-text display-4" id="atendimentosHoje">0</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Tempo Médio</h5>
                            <p class="card-text display-4" id="tempoMedio">0min</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Lista de Pacientes na Fila -->
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Fila de Atendimento</h5>
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Nome</th>
                                    <th>Horário</th>
                                    <th>Prioridade</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody id="filaPacientes">
                                <!-- Preenchido via JavaScript -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>

<script src="<?php echo BASE_URL; ?>/assets/js/fila.js"></script>
<?php require_once '../../includes/footer.php'; ?> 