<?php
if (!defined('BASE_URL')) {
    require_once __DIR__ . '/../config/config.php';
}
?>

<nav class="col-md-3 col-lg-2 d-md-block sidebar collapse">
    <div class="position-sticky pt-3">
        <ul class="nav flex-column">
            <?php if (isMedico()): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : ''; ?>" 
                       href="<?php echo BASE_URL; ?>/pages/medico/dashboard.php">
                        <i class="fas fa-home"></i> Dashboard
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'fila.php' ? 'active' : ''; ?>" 
                       href="<?php echo BASE_URL; ?>/pages/medico/fila.php">
                        <i class="fas fa-list"></i> Fila de Atendimento
                    </a>
                </li>
            <?php endif; ?>

            <?php if (isAdmin()): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : ''; ?>" 
                       href="<?php echo BASE_URL; ?>/pages/admin/dashboard.php">
                        <i class="fas fa-home"></i> Dashboard
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'medicos.php' ? 'active' : ''; ?>" 
                       href="<?php echo BASE_URL; ?>/pages/admin/medicos.php">
                        <i class="fas fa-user-md"></i> Médicos
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'especialidades.php' ? 'active' : ''; ?>" 
                       href="<?php echo BASE_URL; ?>/pages/admin/especialidades.php">
                        <i class="fas fa-stethoscope"></i> Especialidades
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'consultorios.php' ? 'active' : ''; ?>" 
                       href="<?php echo BASE_URL; ?>/pages/admin/consultorios.php">
                        <i class="fas fa-door-closed"></i> Consultórios
                    </a>
                </li>
            <?php endif; ?>
        </ul>
    </div>
</nav> 