class PainelChamada {
    constructor() {
        this.updateInterval = 2000; // 2 segundos
        this.ultimaChamadaId = 0;
        this.initializeEventSource();
    }

    initializeEventSource() {
        const eventSource = new EventSource('../src/fila/stream_chamadas.php');
        
        eventSource.onmessage = (event) => {
            const data = JSON.parse(event.data);
            if (data.id > this.ultimaChamadaId) {
                this.ultimaChamadaId = data.id;
                this.atualizarPainel(data);
                this.reproduzirChamada(data);
            }
        };

        eventSource.onerror = (error) => {
            console.error('Erro na conexão SSE:', error);
            eventSource.close();
            // Tenta reconectar após 5 segundos
            setTimeout(() => this.initializeEventSource(), 5000);
        };
    }

    atualizarPainel(data) {
        // Atualiza o painel principal
        document.getElementById('nomePaciente').textContent = data.nome_paciente;
        document.getElementById('infoMedico').textContent = `Dr(a). ${data.nome_medico}`;
        document.getElementById('infoConsultorio').textContent = `Consultório ${data.consultorio}`;

        // Adiciona ao histórico
        const tbody = document.getElementById('historicoLista');
        const tr = document.createElement('tr');
        tr.innerHTML = `
            <td>${this.formatarHorario(data.horario)}</td>
            <td>${data.nome_paciente}</td>
            <td>Dr(a). ${data.nome_medico}</td>
            <td>${data.consultorio}</td>
        `;
        tbody.insertBefore(tr, tbody.firstChild);

        // Mantém apenas as últimas 10 chamadas
        while (tbody.children.length > 10) {
            tbody.removeChild(tbody.lastChild);
        }

        // Adiciona classe de animação
        tr.classList.add('fade-in');
    }

    reproduzirChamada(data) {
        // Cria a mensagem de voz
        const mensagem = `${data.nome_paciente}, por favor, dirija-se ao consultório ${data.consultorio}`;
        
        // Usa a API de síntese de voz em português
        const utterance = new SpeechSynthesisUtterance(mensagem);
        utterance.lang = 'pt-BR';
        utterance.volume = 1;
        utterance.rate = 0.9;
        utterance.pitch = 1;

        // Reproduz o som de chamada primeiro
        const audio = new Audio('../assets/sounds/chamada.mp3');
        audio.onended = () => {
            window.speechSynthesis.speak(utterance);
        };
        audio.play();
    }

    formatarHorario(datetime) {
        return new Date(datetime).toLocaleTimeString('pt-BR', {
            hour: '2-digit',
            minute: '2-digit',
            second: '2-digit',
            timeZone: 'America/Sao_Paulo'
        });
    }
}

// Inicializa o painel
const painelChamada = new PainelChamada(); 