<?php
require_once 'includes/database.php';

// Carregar dados do JSON
$specialties_json = file_get_contents('data/specialties.json');
$specialties = json_decode($specialties_json, true);

// Conectar ao banco de dados
$db = Database::getInstance()->getConnection();

// Preparar a query de inserção
$stmt = $db->prepare("INSERT INTO specialties (id, name) VALUES (:id, :name)");

// Inserir cada especialidade
foreach ($specialties as $specialty) {
    try {
        $stmt->execute([
            ':id' => $specialty['id'],
            ':name' => $specialty['name']
        ]);
        echo "Especialidade '{$specialty['name']}' migrada com sucesso!\n";
    } catch (PDOException $e) {
        echo "Erro ao migrar especialidade '{$specialty['name']}': " . $e->getMessage() . "\n";
    }
}

echo "Migração de especialidades concluída!\n"; 