<?php
// Configurações de sessão (devem vir antes de session_start)
ini_set('session.gc_maxlifetime', 3600); // 1 hora
ini_set('session.cookie_lifetime', 3600); // 1 hora
ini_set('session.use_strict_mode', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_httponly', 1);
ini_set('session.cookie_secure', 1); // Apenas se usar HTTPS
ini_set('session.cookie_samesite', 'Strict');

// Iniciar sessão depois das configurações
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Configurações de erro (remover em produção)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Configurar timezone
date_default_timezone_set('America/Sao_Paulo');

// Definir constantes do sistema
define('BASE_PATH', dirname(__DIR__));
define('SITE_NAME', 'Sistema de Pacientes');
define('SITE_URL', 'https://weblab.prodigitall.com.br'); // URL correta da Hostinger

// Configurações de segurança
header('X-Frame-Options: DENY');
header('X-XSS-Protection: 1; mode=block');
header('X-Content-Type-Options: nosniff');
header('Referrer-Policy: strict-origin-when-cross-origin');
header("Content-Security-Policy: default-src 'self' https://cdn.jsdelivr.net; style-src 'self' 'unsafe-inline' https://cdn.jsdelivr.net; script-src 'self' 'unsafe-inline' https://cdn.jsdelivr.net");

// Criar diretório de logs se não existir
if (!is_dir(BASE_PATH . '/logs')) {
    mkdir(BASE_PATH . '/logs', 0777, true);
}

// Função para tratamento de erros
function errorHandler($errno, $errstr, $errfile, $errline) {
    $message = date('Y-m-d H:i:s') . " - Erro: [$errno] $errstr - $errfile:$errline\n";
    error_log($message, 3, BASE_PATH . '/logs/error.log');
    
    if (ini_get('display_errors')) {
        echo "Ocorreu um erro. Por favor, tente novamente mais tarde.";
    }
    
    return true;
}

// Registrar handler de erros
set_error_handler('errorHandler');

// Crie o diretório de dados se não existir
$data_dir = BASE_PATH . '/data';
if (!is_dir($data_dir)) {
    mkdir($data_dir, 0777, true);
}