<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TV Indoor</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: Arial, sans-serif;
            overflow: hidden;
            background: #000;
        }

        .slideshow-container {
            width: 100vw;
            height: 100vh;
            position: relative;
        }

        .slide {
            position: absolute;
            width: 100%;
            height: 100%;
            opacity: 0;
            transition: opacity 1.5s ease-in-out;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .slide.active {
            opacity: 1;
        }

        .slide img {
            max-width: 100%;
            max-height: 100%;
            object-fit: contain;
        }
    </style>
</head>
<body>
    <div class="slideshow-container">
        <!-- Os slides serão inseridos aqui dinamicamente -->
    </div>

    <?php
    function getImages() {
        $images = [];
        $valid_extensions = ['jpg', 'jpeg', 'png', 'gif'];
        
        // Verifica se o diretório existe
        if (!is_dir('img')) {
            mkdir('img', 0755, true);
        }
        
        // Lê todos os arquivos do diretório
        $files = scandir('img');
        
        foreach ($files as $file) {
            $ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));
            if (in_array($ext, $valid_extensions)) {
                $images[] = 'img/' . $file;
            }
        }
        
        return $images;
    }
    
    $images = getImages();
    ?>

    <script>
        // Recebe o array de imagens do PHP
        const slides = <?php echo json_encode($images); ?>;

        let currentSlide = 0;
        const SLIDE_DURATION = 8000; // Tempo em milissegundos (8 segundos)

        // Função para criar os slides
        function createSlides() {
            if (slides.length === 0) {
                const container = document.querySelector('.slideshow-container');
                container.innerHTML = '<div style="color: white; text-align: center; width: 100%; padding: 20px;">Nenhuma imagem encontrada na pasta img/</div>';
                return;
            }

            const container = document.querySelector('.slideshow-container');
            slides.forEach((slide, index) => {
                const slideDiv = document.createElement('div');
                slideDiv.className = `slide ${index === 0 ? 'active' : ''}`;
                slideDiv.innerHTML = `<img src="${slide}" alt="Slide ${index + 1}">`;
                container.appendChild(slideDiv);
            });
        }

        // Função para mostrar próximo slide
        function nextSlide() {
            if (slides.length <= 1) return;
            
            const slideElements = document.querySelectorAll('.slide');
            slideElements[currentSlide].classList.remove('active');
            currentSlide = (currentSlide + 1) % slides.length;
            slideElements[currentSlide].classList.add('active');
        }

        // Função para entrar em tela cheia automaticamente
        function autoFullscreen() {
            const element = document.documentElement;
            if (element.requestFullscreen) {
                element.requestFullscreen();
            } else if (element.webkitRequestFullscreen) {
                element.webkitRequestFullscreen();
            } else if (element.msRequestFullscreen) {
                element.msRequestFullscreen();
            }
        }

        // Inicialização
        window.onload = function() {
            createSlides();
            
            // Tenta entrar em tela cheia automaticamente
            autoFullscreen();
            
            // Tenta novamente em caso de falha (alguns navegadores requerem interação do usuário)
            document.addEventListener('click', autoFullscreen);
            
            // Inicia a transição automática apenas se houver mais de uma imagem
            if (slides.length > 1) {
                setInterval(nextSlide, SLIDE_DURATION);
            }

            // Recarrega a página a cada 6 horas para evitar problemas de memória
            setTimeout(() => {
                window.location.reload();
            }, 6 * 60 * 60 * 1000);
        };

        // Previne que a tela saia do modo fullscreen
        document.addEventListener('fullscreenchange', function() {
            if (!document.fullscreenElement) {
                autoFullscreen();
            }
        });

        // Desativa o menu de contexto (clique direito)
        document.addEventListener('contextmenu', event => event.preventDefault());
    </script>
</body>
</html>