<?php
require_once '../config/config.php';
require_once '../config/database.php';

function salvarChamada($dados) {
    global $pdo;
    $stmt = $pdo->prepare("INSERT INTO chamadas (paciente_nome, consultorio_descricao, medico_nome, medico_foto, especialidade, timestamp) VALUES (?, ?, ?, ?, ?, NOW())");
    $stmt->execute([$dados['paciente_nome'], $dados['consultorio_descricao'], $dados['medico_nome'], $dados['medico_foto'], $dados['especialidade']]);
    return $pdo->lastInsertId();
}

function obterUltimaChamada() {
    global $pdo;
    $stmt = $pdo->query("SELECT * FROM chamadas ORDER BY timestamp DESC LIMIT 1");
    return $stmt->fetch(PDO::FETCH_ASSOC);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $dados = json_decode(file_get_contents('php://input'), true);
    $id = salvarChamada($dados);
    echo json_encode(['success' => true, 'id' => $id]);
} elseif ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $ultimaChamada = obterUltimaChamada();
    echo json_encode($ultimaChamada);
}