<?php
require_once '../config/config.php';
require_once '../config/database.php';

header('Content-Type: application/json');

try {
    $database = new Database();
    $db = $database->getConnection();

    // Busca a última chamada não realizada
    $query = "SELECT 
                f.id,
                p.nome as paciente_nome,
                c.descricao as consultorio_descricao,
                u.nome as medico_nome,
                m.foto as medico_foto,
                e.nome as especialidade,
                f.called_at
             FROM fila_atendimento f
             JOIN pacientes p ON f.paciente_id = p.id
             JOIN medicos m ON f.medico_id = m.id
             JOIN usuarios u ON m.usuario_id = u.id
             JOIN consultorios c ON f.consultorio_id = c.id
             JOIN especialidades e ON m.especialidade_id = e.id
             WHERE f.chamada_realizada = 0
             AND f.status = 'chamado'
             ORDER BY f.called_at DESC
             LIMIT 1";

    $stmt = $db->prepare($query);
    $stmt->execute();
    $nova_chamada = $stmt->fetch(PDO::FETCH_ASSOC);

    // Busca as últimas 2 chamadas já realizadas para o histórico
    $query = "SELECT 
                f.id,
                p.nome as paciente_nome,
                c.descricao as consultorio_descricao,
                u.nome as medico_nome,
                m.foto as medico_foto,
                e.nome as especialidade,
                f.called_at
             FROM fila_atendimento f
             JOIN pacientes p ON f.paciente_id = p.id
             JOIN medicos m ON f.medico_id = m.id
             JOIN usuarios u ON m.usuario_id = u.id
             JOIN consultorios c ON f.consultorio_id = c.id
             JOIN especialidades e ON m.especialidade_id = e.id
             WHERE f.chamada_realizada = 1
             AND f.status = 'chamado'
             ORDER BY f.called_at DESC
             LIMIT 2";

    $stmt = $db->prepare($query);
    $stmt->execute();
    $historico = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($nova_chamada) {
        // Marca como realizada
        $query = "UPDATE fila_atendimento SET chamada_realizada = 1 WHERE id = :id";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':id', $nova_chamada['id']);
        $stmt->execute();

        echo json_encode([
            'success' => true,
            'nova_chamada' => true,
            'chamada_atual' => $nova_chamada,
            'chamadas_anteriores' => $historico
        ]);
    } else {
        echo json_encode([
            'success' => true,
            'nova_chamada' => false,
            'chamada_atual' => null,
            'chamadas_anteriores' => $historico
        ]);
    }
} catch(Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
} 