<?php
require_once '../../config/config.php';
require_once '../../config/database.php';

header('Content-Type: application/json');

// Verifica se é médico
if (!isset($_SESSION['user_type']) || $_SESSION['user_type'] !== 'medico') {
    die(json_encode(['success' => false, 'message' => 'Acesso negado']));
}

$database = new Database();
$db = $database->getConnection();

// Chamar paciente
if (isset($_POST['action']) && $_POST['action'] === 'chamar') {
    try {
        // Verifica se o paciente pertence a este médico
        $query = "SELECT f.* FROM fila_atendimento f 
                 JOIN medicos m ON f.medico_id = m.id 
                 WHERE f.id = :id AND m.usuario_id = :usuario_id";
        
        $stmt = $db->prepare($query);
        $stmt->bindParam(':id', $_POST['id']);
        $stmt->bindParam(':usuario_id', $_SESSION['user_id']);
        $stmt->execute();
        
        if (!$stmt->fetch()) {
            throw new Exception('Paciente não encontrado na sua fila');
        }

        // Atualiza o status e horário da chamada
        $query = "UPDATE fila_atendimento 
                 SET status = 'chamado', 
                     called_at = NOW(),
                     chamada_realizada = 0
                 WHERE id = :id";
        
        $stmt = $db->prepare($query);
        $stmt->bindParam(':id', $_POST['id']);
        $result = $stmt->execute();
        
        if ($result) {
            // Busca os dados da chamada
            $query = "SELECT 
                        f.id,
                        p.nome as paciente_nome,
                        c.descricao as consultorio_descricao,
                        u.nome as medico_nome,
                        m.foto as medico_foto,
                        f.called_at
                     FROM fila_atendimento f
                     JOIN pacientes p ON f.paciente_id = p.id
                     JOIN medicos m ON f.medico_id = m.id
                     JOIN usuarios u ON m.usuario_id = u.id
                     JOIN consultorios c ON f.consultorio_id = c.id
                     WHERE f.id = :id";
            
            $stmt = $db->prepare($query);
            $stmt->bindParam(':id', $_POST['id']);
            $stmt->execute();
            $chamada = $stmt->fetch(PDO::FETCH_ASSOC);
            
            // Marca que houve uma nova chamada
            $_SESSION['nova_chamada'] = true;
            
            echo json_encode([
                'success' => true,
                'message' => 'Paciente chamado com sucesso',
                'chamada' => $chamada
            ]);
        } else {
            throw new Exception('Erro ao chamar paciente');
        }
        
    } catch(Exception $e) {
        error_log("Erro ao chamar paciente: " . $e->getMessage());
        echo json_encode(['success' => false, 'message' => $e->getMessage()]);
    }
    exit;
} 

// Buscar fila apenas deste médico
$query = "SELECT 
            f.id, 
            f.tipo_atendimento, 
            f.prioridade, 
            f.status,
            f.horario_agendado,
            f.created_at,
            f.called_at,
            p.nome as paciente_nome, 
            c.descricao as consultorio_nome
          FROM fila_atendimento f
          JOIN pacientes p ON f.paciente_id = p.id
          JOIN consultorios c ON f.consultorio_id = c.id
          WHERE f.medico_id = :medico_id 
          AND f.status IN ('aguardando', 'chamado')
          ORDER BY 
            CASE f.status
                WHEN 'chamado' THEN 2
                ELSE 1
            END,
            CASE 
                WHEN f.status = 'chamado' THEN f.called_at
                ELSE 
                    CASE f.prioridade
                        WHEN 'urgencia' THEN 1
                        WHEN 'idoso' THEN 2
                        WHEN 'pcd' THEN 3
                        WHEN 'gestante' THEN 4
                        ELSE 5
                    END
            END,
            f.created_at ASC"; 