<?php
require_once '../config/config.php';
require_once '../config/database.php';

// Limpa qualquer erro anterior
unset($_SESSION['login_error']);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $login = trim($_POST['login']);
    $senha = $_POST['senha'];

    $database = new Database();
    $db = $database->getConnection();

    try {
        // Busca usuário pelo login
        $query = "SELECT u.*, m.id as medico_id 
                 FROM usuarios u 
                 LEFT JOIN medicos m ON m.usuario_id = u.id 
                 WHERE u.login = ? AND u.senha = ?";
        $stmt = $db->prepare($query);
        $stmt->execute([$login, $senha]);

        if ($row = $stmt->fetch()) {
            $_SESSION['user_id'] = $row['id'];
            $_SESSION['user_name'] = $row['nome'];
            $_SESSION['user_type'] = $row['tipo'];
            
            // Se for médico, guarda o ID do médico também
            if ($row['tipo'] === 'medico') {
                $_SESSION['medico_id'] = $row['medico_id'];
                header('Location: ../pages/medico/dashboard.php');
            } else if ($row['tipo'] === 'admin') {
                header('Location: ../pages/admin/dashboard.php');
            } else {
                header('Location: ../index.php');
            }
            exit;
        }
        
        $_SESSION['login_error'] = 'Usuário ou senha incorretos';
        
    } catch(PDOException $e) {
        error_log($e->getMessage());
        $_SESSION['login_error'] = 'Erro ao realizar login';
    }
}

header('Location: ../index.php');
exit;
?> 