<?php
require_once '../../config/config.php';
require_once '../../config/database.php';

header('Content-Type: application/json');

if (!isLoggedIn() || !isMedico()) {
    echo json_encode(['success' => false, 'message' => 'Acesso não autorizado']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);
$paciente_id = $data['id'] ?? null;

if (!$paciente_id) {
    echo json_encode(['success' => false, 'message' => 'ID do paciente não fornecido']);
    exit;
}

try {
    $database = new Database();
    $db = $database->getConnection();

    // Atualiza o status do paciente
    $query = "UPDATE fila_atendimento 
              SET status = 'chamado', called_at = NOW() 
              WHERE id = :id AND medico_id = :medico_id";
              
    $stmt = $db->prepare($query);
    $stmt->bindParam(':id', $paciente_id);
    $stmt->bindParam(':medico_id', $_SESSION['user_id']);
    
    if ($stmt->execute()) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Erro ao chamar paciente']);
    }

} catch(PDOException $e) {
    handleError($e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Erro ao processar chamada']);
}
?> 