<?php
require_once '../../config/config.php';
require_once '../../config/database.php';

// Verifica se é admin
if (!isset($_SESSION['user_type']) || $_SESSION['user_type'] !== 'admin') {
    die(json_encode(['success' => false, 'message' => 'Acesso negado']));
}

$database = new Database();
$db = $database->getConnection();

// Verifica se existe uma action
if (isset($_POST['action']) || isset($_GET['action'])) {
    
    // CREATE - Criar nova especialidade
    if (isset($_POST['action']) && $_POST['action'] === 'create') {
        $nome = trim($_POST['nome']);
        $descricao = trim($_POST['descricao']);
        
        $query = "INSERT INTO especialidades (nome, descricao) VALUES (:nome, :descricao)";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':nome', $nome);
        $stmt->bindParam(':descricao', $descricao);
        
        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'message' => 'Especialidade criada com sucesso']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Erro ao criar especialidade']);
        }
    }

    // READ - Buscar uma especialidade específica
    if (isset($_GET['action']) && $_GET['action'] === 'read' && isset($_GET['id'])) {
        $id = $_GET['id'];
        
        $query = "SELECT * FROM especialidades WHERE id = :id";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':id', $id);
        $stmt->execute();
        
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        echo json_encode($result);
        exit;
    }

    // UPDATE - Atualizar especialidade
    if (isset($_POST['action']) && $_POST['action'] === 'update') {
        $id = $_POST['id'];
        $nome = trim($_POST['nome']);
        $descricao = trim($_POST['descricao']);
        
        $query = "UPDATE especialidades SET nome = :nome, descricao = :descricao WHERE id = :id";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':id', $id);
        $stmt->bindParam(':nome', $nome);
        $stmt->bindParam(':descricao', $descricao);
        
        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'message' => 'Especialidade atualizada com sucesso']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Erro ao atualizar especialidade']);
        }
    }

    // DELETE - Excluir especialidade
    if (isset($_POST['action']) && $_POST['action'] === 'delete') {
        $id = $_POST['id'];
        
        $query = "DELETE FROM especialidades WHERE id = :id";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':id', $id);
        
        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'message' => 'Especialidade excluída com sucesso']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Erro ao excluir especialidade']);
        }
    }
} 