<?php
require_once '../../config/config.php';
require_once '../../config/database.php';

// Verifica se é admin
if (!isset($_SESSION['user_type']) || $_SESSION['user_type'] !== 'admin') {
    die(json_encode(['success' => false, 'message' => 'Acesso negado']));
}

$database = new Database();
$db = $database->getConnection();

// Verifica se existe uma action
if (isset($_POST['action']) || isset($_GET['action'])) {
    
    // READ - Buscar um consultório específico
    if (isset($_GET['action']) && $_GET['action'] === 'read' && isset($_GET['id'])) {
        $id = $_GET['id'];
        
        $query = "SELECT * FROM consultorios WHERE id = :id";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':id', $id);
        $stmt->execute();
        
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        echo json_encode($result);
        exit;
    }

    // CREATE - Criar novo consultório
    if (isset($_POST['action']) && $_POST['action'] === 'create') {
        // Validação do número
        if (!isset($_POST['numero']) || empty(trim($_POST['numero']))) {
            echo json_encode(['success' => false, 'message' => 'O número do consultório é obrigatório']);
            exit;
        }

        $numero = trim($_POST['numero']);
        $descricao = trim($_POST['descricao'] ?? '');
        
        $query = "INSERT INTO consultorios (numero, descricao) VALUES (:numero, :descricao)";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':numero', $numero);
        $stmt->bindParam(':descricao', $descricao);
        
        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'message' => 'Consultório criado com sucesso']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Erro ao criar consultório']);
        }
        exit;
    }

    // UPDATE - Atualizar consultório
    if (isset($_POST['action']) && $_POST['action'] === 'update') {
        $id = $_POST['id'];
        $numero = trim($_POST['numero']);
        $descricao = trim($_POST['descricao']);
        
        $query = "UPDATE consultorios SET numero = :numero, descricao = :descricao WHERE id = :id";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':id', $id);
        $stmt->bindParam(':numero', $numero);
        $stmt->bindParam(':descricao', $descricao);
        
        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'message' => 'Consultório atualizado com sucesso']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Erro ao atualizar consultório']);
        }
        exit;
    }

    // DELETE - Excluir consultório
    if (isset($_POST['action']) && $_POST['action'] === 'delete') {
        $id = $_POST['id'];
        
        $query = "DELETE FROM consultorios WHERE id = :id";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':id', $id);
        
        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'message' => 'Consultório excluído com sucesso']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Erro ao excluir consultório']);
        }
        exit;
    }
} 