<?php
require_once '../../config/config.php';
require_once '../../includes/auth_medico.php';
require_once '../../includes/header.php';

// Busca dados do médico incluindo a foto
$database = new Database();
$db = $database->getConnection();

$query = "SELECT m.*, u.nome 
          FROM medicos m 
          JOIN usuarios u ON m.usuario_id = u.id 
          WHERE m.id = :medico_id";
$stmt = $db->prepare($query);
$stmt->bindParam(':medico_id', $_SESSION['medico_id']);
$stmt->execute();
$medico = $stmt->fetch(PDO::FETCH_ASSOC);
?>

<div class="container mt-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5>Dashboard Médico</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex align-items-center mb-4">
                        <?php if (!empty($medico['foto'])): ?>
                            <img src="<?php echo BASE_URL; ?>/uploads/medicos/<?php echo $medico['foto']; ?>" 
                                 class="rounded-circle me-3" width="60" height="60" 
                                 alt="Foto do médico">
                        <?php else: ?>
                            <img src="https://cdn.pixabay.com/photo/2016/08/08/09/17/avatar-1577909_1280.png" 
                                 class="rounded-circle me-3" width="60" height="60" 
                                 alt="Foto padrão">
                        <?php endif; ?>
                        <h4>Bem vindo, Dr(a). <?php echo $_SESSION['user_name']; ?></h4>
                    </div>
                    <!-- Conteúdo do dashboard -->
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once '../../includes/footer.php'; ?> 