<?php
require_once '../../config/config.php';
require_once '../../includes/auth_admin.php';
require_once '../../includes/header.php';

$database = new Database();
$db = $database->getConnection();

// Busca médicos ativos
$query = "SELECT m.*, u.nome as nome_medico, c.numero as consultorio_numero 
          FROM medicos m 
          JOIN usuarios u ON m.usuario_id = u.id 
          JOIN consultorios c ON m.consultorio_id = c.id 
          WHERE m.status = 'ativo'";
$stmt = $db->prepare($query);
$stmt->execute();
$medicos = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container mt-4">
    <div class="card">
        <div class="card-header">
            <h5>Recepção - Adicionar à Fila</h5>
        </div>
        <div class="card-body">
            <form id="formFila">
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label">Buscar Paciente</label>
                        <div class="input-group">
                            <input type="text" class="form-control" id="busca_paciente" placeholder="Digite CPF ou Nome">
                            <button type="button" class="btn btn-primary" onclick="buscarPaciente()">Buscar</button>
                        </div>
                    </div>
                </div>

                <div id="dados_paciente" style="display:none;">
                    <input type="hidden" id="paciente_id" name="paciente_id">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">Nome do Paciente</label>
                            <input type="text" class="form-control" id="nome_paciente" readonly>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">CPF</label>
                            <input type="text" class="form-control" id="cpf_paciente" readonly>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label class="form-label">Médico *</label>
                            <select class="form-control" name="medico_id" required onchange="atualizaConsultorio(this.value)">
                                <option value="">Selecione...</option>
                                <?php foreach ($medicos as $medico): ?>
                                    <option value="<?php echo $medico['id']; ?>" 
                                            data-consultorio="<?php echo $medico['consultorio_id']; ?>"
                                            data-consultorio-numero="<?php echo $medico['consultorio_numero']; ?>">
                                        Dr(a). <?php echo $medico['nome_medico']; ?> - Consultório <?php echo $medico['consultorio_numero']; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Tipo de Atendimento *</label>
                            <select class="form-control" name="tipo_atendimento" required onchange="toggleHorarioAgendado(this.value)">
                                <option value="normal">Chegada</option>
                                <option value="agendado">Agendado</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Prioridade *</label>
                            <select class="form-control" name="prioridade" required>
                                <option value="normal">Normal</option>
                                <option value="idoso">Idoso</option>
                                <option value="gestante">Gestante</option>
                                <option value="pcd">PCD</option>
                                <option value="urgencia">Urgência</option>
                            </select>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-4" id="div_horario_agendado" style="display:none;">
                            <label class="form-label">Horário Agendado *</label>
                            <input type="time" class="form-control" name="horario_agendado">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Consultório</label>
                            <input type="text" class="form-control" id="consultorio_numero" readonly>
                            <input type="hidden" name="consultorio_id" id="consultorio_id">
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-12">
                            <label class="form-label">Observações</label>
                            <textarea class="form-control" name="observacoes" rows="2"></textarea>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-primary">Adicionar à Fila</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal de Múltiplos Pacientes -->
<div class="modal fade" id="multiplosPacientesModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Selecione o Paciente</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="list-group" id="lista-pacientes">
                    <!-- Lista será preenchida via JavaScript -->
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Scripts - Nova ordem e CDN -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://raw.githubusercontent.com/igorescobar/jQuery-Mask-Plugin/master/dist/jquery.mask.min.js"></script>
<!-- OU tente este CDN alternativo -->
<script src="https://igorescobar.github.io/jQuery-Mask-Plugin/js/jquery.mask.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script>

<script>
// Aguarda todos os scripts carregarem
window.onload = function() {
    // Verifica se o plugin mask está disponível
    if(typeof $.fn.mask !== 'undefined') {
        // Remove a máscara do campo de busca para aceitar nome
        // $('#busca_paciente').mask('000.000.000-00');
        $('#cpf_paciente').mask('000.000.000-00');
    } else {
        // Tenta carregar o plugin novamente
        $.getScript('https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js', function() {
            // $('#busca_paciente').mask('000.000.000-00');
            $('#cpf_paciente').mask('000.000.000-00');
        });
    }
};

const BASE_URL = '<?php echo BASE_URL; ?>';

function buscarPaciente() {
    const busca = $('#busca_paciente').val();
    
    // Remove qualquer máscara se for CPF
    const buscaSemMascara = busca.replace(/\D/g, '');
    
    // Se for CPF (11 dígitos) aplica a máscara
    if (buscaSemMascara.length === 11) {
        const cpfFormatado = buscaSemMascara.replace(/(\d{3})(\d{3})(\d{3})(\d{2})/, "$1.$2.$3-$4");
        $('#busca_paciente').val(cpfFormatado);
    }
    
    fetch(`${BASE_URL}/src/admin/fila.php?action=buscar_paciente&busca=${encodeURIComponent(busca)}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                if (data.multiplos) {
                    // Preenche e mostra modal com múltiplos pacientes
                    const lista = $('#lista-pacientes');
                    lista.empty();
                    
                    data.pacientes.forEach(paciente => {
                        lista.append(`
                            <a href="#" class="list-group-item list-group-item-action" 
                               onclick="selecionarPaciente(${paciente.id}, '${paciente.nome}', '${paciente.cpf}')">
                                ${paciente.nome} - CPF: ${paciente.cpf}
                            </a>
                        `);
                    });
                    
                    new bootstrap.Modal(document.getElementById('multiplosPacientesModal')).show();
                } else {
                    // Paciente único encontrado
                    selecionarPaciente(data.paciente.id, data.paciente.nome, data.paciente.cpf);
                }
            } else {
                alert(data.message);
            }
        });
}

function selecionarPaciente(id, nome, cpf) {
    $('#paciente_id').val(id);
    $('#nome_paciente').val(nome);
    $('#cpf_paciente').val(cpf);
    $('#dados_paciente').show();
    
    // Fecha o modal se estiver aberto
    const modal = bootstrap.Modal.getInstance(document.getElementById('multiplosPacientesModal'));
    if (modal) modal.hide();
}

function toggleHorarioAgendado(tipo) {
    $('#div_horario_agendado').toggle(tipo === 'agendado');
    $('input[name="horario_agendado"]').prop('required', tipo === 'agendado');
}

function atualizaConsultorio(medicoId) {
    const option = $(`select[name="medico_id"] option[value="${medicoId}"]`);
    const consultorioId = option.data('consultorio');
    const consultorioNumero = option.data('consultorio-numero');
    
    $('#consultorio_id').val(consultorioId);
    $('#consultorio_numero').val(`Consultório ${consultorioNumero}`);
}

$('#formFila').on('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    formData.append('action', 'adicionar_fila');

    fetch(`${BASE_URL}/src/admin/fila.php`, {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Paciente adicionado à fila com sucesso!');
            location.reload();
        } else {
            alert(data.message);
        }
    });
});
</script>

<?php require_once '../../includes/footer.php'; ?> 