<?php
require_once '../../config/config.php';
require_once '../../includes/auth.php';
requireAdmin();
require_once '../../includes/header.php';

// Conexão com o banco
$database = new Database();
$db = $database->getConnection();

// Busca médicos
$query = "SELECT m.*, u.nome, e.nome as especialidade 
          FROM medicos m 
          JOIN usuarios u ON m.usuario_id = u.id 
          JOIN especialidades e ON m.especialidade_id = e.id 
          ORDER BY u.nome";
$stmt = $db->prepare($query);
$stmt->execute();
$medicos = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Busca especialidades para o select
$query = "SELECT * FROM especialidades ORDER BY nome";
$stmt = $db->prepare($query);
$stmt->execute();
$especialidades = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Busca consultorios para o select
$query = "SELECT * FROM consultorios ORDER BY numero";
$stmt = $db->prepare($query);
$stmt->execute();
$consultorios = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container mt-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="float-start">Médicos</h5>
                    <button class="btn btn-primary float-end" data-bs-toggle="modal" data-bs-target="#addMedicoModal">
                        Novo Médico
                    </button>
                </div>
                <div class="card-body">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Foto</th>
                                <th>Nome</th>
                                <th>CRM</th>
                                <th>Especialidade</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($medicos)): ?>
                                <tr>
                                    <td colspan="5" class="text-center">Nenhum médico cadastrado</td>
                                </tr>
                            <?php else: ?>
                                <?php foreach ($medicos as $med): ?>
                                    <tr>
                                        <td>
                                            <?php if (!empty($med['foto'])): ?>
                                                <img src="<?php echo BASE_URL; ?>/uploads/medicos/<?php echo $med['foto']; ?>" 
                                                     class="rounded-circle" width="50" height="50" 
                                                     alt="Foto do médico">
                                            <?php else: ?>
                                                <img src="https://cdn.pixabay.com/photo/2016/08/08/09/17/avatar-1577909_1280.png" 
                                                     class="rounded-circle" width="50" height="50" 
                                                     alt="Foto padrão">
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo $med['nome']; ?></td>
                                        <td><?php echo $med['crm']; ?></td>
                                        <td><?php echo $med['especialidade']; ?></td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <button class="btn btn-primary btn-sm" onclick="editarMedico(<?php echo $med['id']; ?>)">
                                                    <i class="fas fa-edit"></i>
                                                </button>
                                                <button class="btn btn-danger btn-sm" onclick="if(confirm('Deseja realmente excluir este médico?')) excluirMedico(<?php echo $med['id']; ?>)">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal Adicionar Médico -->
<div class="modal fade" id="addMedicoModal">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Novo Médico</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="formMedico" enctype="multipart/form-data">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Nome *</label>
                                <input type="text" class="form-control" name="nome" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">CRM</label>
                                <input type="text" class="form-control" name="crm">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">E-mail</label>
                                <input type="email" class="form-control" name="email">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">WhatsApp</label>
                                <input type="text" class="form-control" name="whatsapp" id="whatsapp">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Especialidade *</label>
                                <select class="form-control" name="especialidade_id" required>
                                    <option value="">Selecione...</option>
                                    <?php foreach ($especialidades as $esp): ?>
                                        <option value="<?php echo $esp['id']; ?>">
                                            <?php echo $esp['nome']; ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Consultório *</label>
                                <select class="form-control" name="consultorio_id" required>
                                    <option value="">Selecione...</option>
                                    <?php foreach ($consultorios as $cons): ?>
                                        <option value="<?php echo $cons['id']; ?>">
                                            <?php echo $cons['numero'] . ' - ' . $cons['descricao']; ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Status</label>
                                <select class="form-control" name="status">
                                    <option value="ativo">Ativo</option>
                                    <option value="inativo">Inativo</option>
                                    <option value="ferias">Férias</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Foto</label>
                                <input type="file" class="form-control" name="foto" accept="image/*">
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Observações</label>
                        <textarea class="form-control" name="observacoes" rows="3"></textarea>
                    </div>
                    <hr>
                    <h6>Dados de Acesso</h6>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Login *</label>
                                <input type="text" class="form-control" name="login" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Senha *</label>
                                <input type="password" class="form-control" name="senha" required>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Salvar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php require_once '../../includes/footer.php'; ?>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/jquery-mask-plugin@1.14.16/dist/jquery.mask.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script>

<script>
// Aguarda o documento carregar completamente
$(document).ready(function(){
    // Aplica máscara no WhatsApp
    if($.fn.mask){
        $('#whatsapp').mask('(00) 00000-0000');
    }

    // Quando abrir o modal (tanto novo quanto edição)
    $('#addMedicoModal').on('show.bs.modal', function (event) {
        const button = $(event.relatedTarget);
        
        // Se for o botão "Novo Médico"
        if (button.hasClass('btn-primary')) {
            // Limpa o formulário
            $('#formMedico').trigger('reset');
            $('#formMedico').removeData('id');
            $('#formMedico input[name="senha"]').prop('required', true);
            $('#formMedico select').prop('selectedIndex', 0);
            $('#formMedico select[name="status"]').val('ativo');
            
            // Muda o título do modal
            $('.modal-title').text('Novo Médico');
        } else {
            // Muda o título do modal
            $('.modal-title').text('Editar Médico');
        }
    });

    // Formulário de médico
    $('#formMedico').on('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        formData.append('action', $(this).data('id') ? 'update' : 'create');
        if ($(this).data('id')) {
            formData.append('id', $(this).data('id'));
        }

        // Debug detalhado
        console.log('URL:', `${BASE_URL}/src/admin/medico.php`);
        console.log('Método:', 'POST');
        console.log('Dados enviados:');
        for (var pair of formData.entries()) {
            console.log(pair[0]+ ': ' + pair[1]); 
        }

        fetch(`${BASE_URL}/src/admin/medico.php`, {
            method: 'POST',
            body: formData
        })
        .then(response => {
            console.log('Status da resposta:', response.status);
            return response.text(); // Mudado para text() para ver a resposta bruta
        })
        .then(text => {
            console.log('Resposta bruta:', text);
            try {
                const data = JSON.parse(text);
                console.log('Resposta parseada:', data);
                if (data.success) {
                    location.reload();
                } else {
                    alert(data.message || 'Erro ao processar requisição');
                }
            } catch (e) {
                console.error('Erro ao parsear resposta:', e);
                alert('Erro ao processar resposta do servidor');
            }
        })
        .catch(error => {
            console.error('Erro na requisição:', error);
            alert('Erro ao processar requisição: ' + error.message);
        });
    });
});

// Funções globais
const BASE_URL = '<?php echo BASE_URL; ?>';

function editarMedico(id) {
    console.log('Editando médico:', id); // Debug
    
    fetch(`${BASE_URL}/src/admin/medico.php?action=read&id=${id}`)
        .then(response => response.json())
        .then(data => {
            console.log('Dados recebidos:', data); // Debug
            
            // Preenche os campos
            $('#formMedico input[name="nome"]').val(data.nome);
            $('#formMedico input[name="crm"]').val(data.crm);
            $('#formMedico input[name="whatsapp"]').val(data.whatsapp);
            $('#formMedico select[name="especialidade_id"]').val(data.especialidade_id);
            $('#formMedico select[name="consultorio_id"]').val(data.consultorio_id);
            $('#formMedico select[name="status"]').val(data.status);
            $('#formMedico textarea[name="observacoes"]').val(data.observacoes);
            $('#formMedico input[name="login"]').val(data.login);
            $('#formMedico input[name="senha"]').prop('required', false);
            
            // Marca o formulário como edição
            $('#formMedico').data('id', id);
            
            // Abre o modal
            new bootstrap.Modal(document.getElementById('addMedicoModal')).show();
        })
        .catch(error => {
            console.error('Erro:', error);
            alert('Erro ao carregar dados do médico');
        });
}

function excluirMedico(id) {
    if (confirm('Deseja realmente excluir este médico?')) {
        const formData = new FormData();
        formData.append('action', 'delete');
        formData.append('id', id);

        fetch(`${BASE_URL}/src/admin/medico.php`, {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message);
            }
        });
    }
}
</script> 