<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

try {
    require_once '../../config/config.php';
    error_log("Config carregado");
    
    require_once '../../includes/auth.php';
    error_log("Auth carregado");
    
    requireAdmin();
    error_log("Admin verificado");
    
    require_once '../../includes/header.php';
    error_log("Header carregado");

    // Conexão com o banco
    $database = new Database();
    $db = $database->getConnection();
    error_log("Conexão com banco estabelecida");

    // Busca especialidades
    $query = "SELECT * FROM especialidades ORDER BY nome";
    $stmt = $db->prepare($query);
    $stmt->execute();
    $especialidades = $stmt->fetchAll(PDO::FETCH_ASSOC);
    error_log("Especialidades buscadas: " . count($especialidades));

    // Busca consultórios
    $query = "SELECT * FROM consultorios ORDER BY numero";
    $stmt = $db->prepare($query);
    $stmt->execute();
    $consultorios = $stmt->fetchAll(PDO::FETCH_ASSOC);
    error_log("Consultórios encontrados: " . count($consultorios));
} catch (Exception $e) {
    error_log("Erro na página especialidades.php: " . $e->getMessage());
    die("Erro: " . $e->getMessage());
}
?>

<div class="container mt-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="float-start">Especialidades</h5>
                    <button class="btn btn-primary float-end" data-bs-toggle="modal" data-bs-target="#addEspecialidadeModal">
                        Nova Especialidade
                    </button>
                </div>
                <div class="card-body">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Nome</th>
                                <th>Descrição</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($especialidades)): ?>
                                <tr>
                                    <td colspan="3" class="text-center">Nenhuma especialidade cadastrada</td>
                                </tr>
                            <?php else: ?>
                                <?php foreach ($especialidades as $esp): ?>
                                    <tr>
                                        <td><?php echo $esp['nome']; ?></td>
                                        <td><?php echo $esp['descricao']; ?></td>
                                        <td>
                                            <button class="btn btn-sm btn-info" onclick="editarEspecialidade(<?php echo $esp['id']; ?>)">
                                                Editar
                                            </button>
                                            <button class="btn btn-sm btn-danger" onclick="excluirEspecialidade(<?php echo $esp['id']; ?>)">
                                                Excluir
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal Adicionar Especialidade -->
<div class="modal fade" id="addEspecialidadeModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Nova Especialidade</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="formEspecialidade">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Nome</label>
                        <input type="text" class="form-control" name="nome" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Descrição</label>
                        <textarea class="form-control" name="descricao"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Salvar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Adicionar Consultório -->
<div class="modal fade" id="addConsultorioModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Novo Consultório</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="formConsultorio">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Número</label>
                        <input type="text" class="form-control" name="numero" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Descrição</label>
                        <textarea class="form-control" name="descricao"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Salvar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Bootstrap JS e dependências -->
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script>

<script>
// Define a URL base para o JavaScript
const BASE_URL = '<?php echo BASE_URL; ?>';

// Funções para Especialidades
function editarEspecialidade(id) {
    fetch(`${BASE_URL}/src/admin/especialidade.php?action=read&id=${id}`)
        .then(response => response.json())
        .then(data => {
            document.querySelector('#formEspecialidade input[name="nome"]').value = data.nome;
            document.querySelector('#formEspecialidade textarea[name="descricao"]').value = data.descricao;
            document.querySelector('#formEspecialidade').dataset.id = id;
            
            const modal = new bootstrap.Modal(document.getElementById('addEspecialidadeModal'));
            modal.show();
        });
}

function excluirEspecialidade(id) {
    if (confirm('Deseja realmente excluir esta especialidade?')) {
        const formData = new FormData();
        formData.append('action', 'delete');
        formData.append('id', id);

        fetch(`${BASE_URL}/src/admin/especialidade.php`, {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message);
            }
        });
    }
}

// Funções para Consultórios
function editarConsultorio(id) {
    fetch(`${BASE_URL}/src/admin/consultorio.php?action=read&id=${id}`)
        .then(response => response.json())
        .then(data => {
            document.querySelector('#formConsultorio input[name="numero"]').value = data.numero;
            document.querySelector('#formConsultorio textarea[name="descricao"]').value = data.descricao;
            document.querySelector('#formConsultorio').dataset.id = id;
            
            const modal = new bootstrap.Modal(document.getElementById('addConsultorioModal'));
            modal.show();
        });
}

function excluirConsultorio(id) {
    if (confirm('Deseja realmente excluir este consultório?')) {
        const formData = new FormData();
        formData.append('action', 'delete');
        formData.append('id', id);

        fetch(`${BASE_URL}/src/admin/consultorio.php`, {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message);
            }
        });
    }
}

// Tratamento dos formulários
document.getElementById('formEspecialidade').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    formData.append('action', this.dataset.id ? 'update' : 'create');
    if (this.dataset.id) {
        formData.append('id', this.dataset.id);
    }

    fetch(`${BASE_URL}/src/admin/especialidade.php`, {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        } else {
            alert(data.message);
        }
    });
});

document.getElementById('formConsultorio').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    formData.append('action', this.dataset.id ? 'update' : 'create');
    if (this.dataset.id) {
        formData.append('id', this.dataset.id);
    }

    fetch(`${BASE_URL}/src/admin/consultorio.php`, {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        } else {
            alert(data.message);
        }
    });
});
</script>

<?php require_once '../../includes/footer.php'; ?> 