<?php
require_once '../../config/config.php';
require_once '../../includes/auth.php';
requireAdmin();
require_once '../../includes/header.php';

// Período para as estatísticas
$data_inicio = "2025-02-09";
$data_fim = "2025-02-15";
?>

<div class="container-fluid mt-4">
    <div class="row">
        <main class="col-12">
            <!-- Cards Principais -->
            <div class="row mb-4">
                <!-- Novos Pacientes -->
                <div class="col-md-4">
                    <div class="card bg-primary text-white">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <i class="fas fa-user-plus fa-3x me-3"></i>
                                <div>
                                    <h6 class="card-title">Novos Pacientes</h6>
                                    <h2 class="mb-0">117</h2>
                                </div>
                            </div>
                            <div class="progress mt-3" style="height: 10px;">
                                <div class="progress-bar bg-white" style="width: 75%"></div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Médicos Cadastrados -->
                <div class="col-md-4">
                    <div class="card bg-info text-white">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <i class="fas fa-user-md fa-3x me-3"></i>
                                <div>
                                    <h6 class="card-title">Médico Cadastrado</h6>
                                    <h2 class="mb-0">0</h2>
                                </div>
                            </div>
                            <div class="progress mt-3" style="height: 10px;">
                                <div class="progress-bar bg-white" style="width: 0%"></div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Total Atendimentos -->
                <div class="col-md-4">
                    <div class="card bg-primary text-white">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <i class="fas fa-calendar-check fa-3x me-3"></i>
                                <div>
                                    <h6 class="card-title">Total Atendimento Cadastrado</h6>
                                    <h2 class="mb-0">247</h2>
                                    <small><?php echo date('d/m/Y', strtotime($data_inicio)); ?> a <?php echo date('d/m/Y', strtotime($data_fim)); ?></small>
                                </div>
                            </div>
                            <div class="progress mt-3" style="height: 10px;">
                                <div class="progress-bar bg-white" style="width: 85%"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Gráfico e Cards Laterais -->
            <div class="row">
                <!-- Gráfico -->
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Estatística Semanal Atendimento</h5>
                            <canvas id="graficoAtendimentos"></canvas>
                        </div>
                    </div>
                </div>

                <!-- Cards Laterais -->
                <div class="col-md-4">
                    <!-- Agendamento -->
                    <div class="card mb-4 bg-primary text-white">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-3">
                                <i class="fas fa-calendar-alt fa-2x me-3"></i>
                                <h5 class="card-title mb-0">Agendamento Agendado</h5>
                            </div>
                            <p class="mb-1"><?php echo date('d/m/Y', strtotime($data_inicio)); ?> a <?php echo date('d/m/Y', strtotime($data_fim)); ?></p>
                            <p class="mb-1">Agendado (77)</p>
                            <p class="mb-1">Cancelado (13)</p>
                            <p class="mb-0">Atendimento (166)</p>
                        </div>
                    </div>

                    <!-- Especialidades -->
                    <div class="card bg-info text-white">
                        <div class="card-body">
                            <div class="d-flex align-items-center mb-3">
                                <i class="fas fa-stethoscope fa-2x me-3"></i>
                                <h5 class="card-title mb-0">Especialidades</h5>
                            </div>
                            <p class="mb-1"><?php echo date('d/m/Y', strtotime($data_inicio)); ?> a <?php echo date('d/m/Y', strtotime($data_fim)); ?></p>
                            <p class="mb-1">ALERGISTA (2)</p>
                            <p class="mb-1">CARDIOLOGISTA (14)</p>
                            <p class="mb-1">CLINICO GERAL (13)</p>
                            <p class="mb-1">DERMATOLOGISTA (12)</p>
                            <p class="mb-1">ENDOCRINOLOGIA (24)</p>
                            <p class="mb-0">ANGIOLOGIA (3)</p>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>

<!-- Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
// Dados do gráfico
const ctx = document.getElementById('graficoAtendimentos').getContext('2d');
new Chart(ctx, {
    type: 'line',
    data: {
        labels: ['09-02', '10-02', '11-02', '12-02', '13-02', '14-02', '15-02'],
        datasets: [{
            label: 'Agendado',
            data: [0, 25, 55, 22, 18, 35, 8],
            borderColor: '#36A2EB',
            tension: 0.4
        }, {
            label: 'Realizado',
            data: [0, 30, 90, 30, 25, 55, 15],
            borderColor: '#FF6384',
            tension: 0.4
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true,
                max: 100
            }
        }
    }
});
</script>

<?php require_once '../../includes/footer.php'; ?> 