<?php
require_once 'config/config.php';
require_once 'includes/header.php';

// Se já estiver logado, redireciona
if (isset($_SESSION['user_id'])) {
    if ($_SESSION['user_type'] == 'admin') {
        header("Location: pages/admin/dashboard.php");
        exit;
    } else if ($_SESSION['user_type'] == 'medico') {
        header("Location: pages/medico/dashboard.php");
        exit;
    }
}

// Mensagem de erro (se houver)
$error = '';
if (isset($_SESSION['login_error'])) {
    $error = $_SESSION['login_error'];
    unset($_SESSION['login_error']);
}
?>

<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card">
                <div class="card-body text-center">
                    <h2 class="mb-4">Acesso ao Sistema</h2>
                    
                    <?php if ($error): ?>
                        <div class="alert alert-danger"><?php echo $error; ?></div>
                    <?php endif; ?>

                    <form action="src/login.php" method="POST">
                        <div class="mb-3">
                            <label class="form-label">Login</label>
                            <input type="text" class="form-control" name="login" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Senha</label>
                            <input type="password" class="form-control" name="senha" required>
                        </div>
                        <button type="submit" class="btn btn-primary w-100">Entrar</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?> 