-- Configuração do timezone (UTC-3 para São Paulo)
SET time_zone = '-03:00';

CREATE TABLE usuarios (
    id INT PRIMARY KEY AUTO_INCREMENT,
    nome VARCHAR(100) NOT NULL UNIQUE,
    senha VARCHAR(255) NOT NULL,
    tipo ENUM('admin', 'medico') NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE especialidades (
    id INT PRIMARY KEY AUTO_INCREMENT,
    nome VARCHAR(100) NOT NULL,
    descricao TEXT
);

CREATE TABLE medicos (
    id INT PRIMARY KEY AUTO_INCREMENT,
    usuario_id INT,
    especialidade_id INT,
    crm VARCHAR(20) NOT NULL,
    FOREIGN KEY (usuario_id) REFERENCES usuarios(id),
    FOREIGN KEY (especialidade_id) REFERENCES especialidades(id)
);

CREATE TABLE consultorios (
    id INT PRIMARY KEY AUTO_INCREMENT,
    numero VARCHAR(10) NOT NULL,
    descricao TEXT
);

CREATE TABLE pacientes (
    id INT PRIMARY KEY AUTO_INCREMENT,
    nome VARCHAR(100) NOT NULL,
    cpf VARCHAR(14) UNIQUE,
    data_nascimento DATE,
    telefone VARCHAR(15),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE fila_atendimento (
    id INT PRIMARY KEY AUTO_INCREMENT,
    paciente_id INT,
    medico_id INT,
    consultorio_id INT,
    status ENUM('aguardando', 'chamado', 'em_atendimento', 'finalizado') DEFAULT 'aguardando',
    prioridade BOOLEAN DEFAULT FALSE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    called_at TIMESTAMP NULL,
    FOREIGN KEY (paciente_id) REFERENCES pacientes(id),
    FOREIGN KEY (medico_id) REFERENCES medicos(id),
    FOREIGN KEY (consultorio_id) REFERENCES consultorios(id)
);

-- Primeiro vamos criar um usuário administrador
-- Senha: admin123
INSERT INTO usuarios (nome, senha, tipo) VALUES 
('admin', '$2y$10$Hy4Qx9P6h5TvmGYVjQXBzOEHg7bqZyRmqzEw3.dO9q9w.CCxzZYpC', 'admin');

-- Vamos adicionar algumas especialidades básicas
INSERT INTO especialidades (nome, descricao) VALUES 
('Clínica Geral', 'Atendimento geral de pacientes'),
('Pediatria', 'Atendimento especializado em crianças'),
('Cardiologia', 'Especialidade focada em doenças do coração');

-- Vamos adicionar alguns consultórios
INSERT INTO consultorios (numero, descricao) VALUES 
('101', 'Consultório 1 - Primeiro Andar'),
('102', 'Consultório 2 - Primeiro Andar'),
('103', 'Consultório 3 - Primeiro Andar'); 