<?php
class Database {
    private static $instance = null;
    private $connection;

    private function __construct() {
        try {
            // Configurações para Hostinger
            $this->connection = new PDO(
                "mysql:host=localhost;dbname=prodi970_weblab;charset=utf8mb4",
                "prodi970_weblab",
                "MXZz^J7tZt@l",
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false,
                    PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci"
                ]
            );
        } catch (PDOException $e) {
            error_log("Erro de conexão: " . $e->getMessage());
            die("Erro ao conectar ao banco de dados. Por favor, tente novamente mais tarde.");
        }
    }

    private function __clone() {}

    public function __wakeup() {
        throw new Exception("Cannot unserialize singleton");
    }

    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function getConnection() {
        return $this->connection;
    }

    public function query($sql, $params = []) {
        try {
            $stmt = $this->connection->prepare($sql);
            $stmt->execute($params);
            return $stmt;
        } catch (PDOException $e) {
            error_log("Erro na query: " . $e->getMessage());
            error_log("SQL: " . $sql);
            error_log("Params: " . print_r($params, true));
            throw $e;
        }
    }

    public function insert($table, $data) {
        $fields = array_keys($data);
        $placeholders = array_map(function($field) {
            return ":$field";
        }, $fields);
        
        $sql = sprintf(
            "INSERT INTO %s (%s) VALUES (%s)",
            $table,
            implode(", ", $fields),
            implode(", ", $placeholders)
        );
        
        return $this->query($sql, $data);
    }

    public function update($table, $data, $where) {
        $fields = array_map(function($field) {
            return "$field = :$field";
        }, array_keys($data));
        
        $whereFields = array_map(function($field) {
            return "$field = :where_$field";
        }, array_keys($where));
        
        $sql = sprintf(
            "UPDATE %s SET %s WHERE %s",
            $table,
            implode(", ", $fields),
            implode(" AND ", $whereFields)
        );
        
        $params = $data;
        foreach ($where as $key => $value) {
            $params["where_$key"] = $value;
        }
        
        return $this->query($sql, $params);
    }

    public function delete($table, $where) {
        $whereFields = array_map(function($field) {
            return "$field = :$field";
        }, array_keys($where));
        
        $sql = sprintf(
            "DELETE FROM %s WHERE %s",
            $table,
            implode(" AND ", $whereFields)
        );
        
        return $this->query($sql, $where);
    }
} 