<?php
header('Content-Type: application/json');

$patients_file = 'data/patients.json';
$offices_file = 'data/offices.json';

// Função para carregar pacientes
function loadPatients() {
    global $patients_file;
    if (!file_exists($patients_file)) {
        return [];
    }
    return json_decode(file_get_contents($patients_file), true) ?: [];
}

// Função para carregar consultórios
function loadOffices() {
    global $offices_file;
    if (!file_exists($offices_file)) {
        return [];
    }
    return json_decode(file_get_contents($offices_file), true) ?: [];
}

// Função para obter nome do consultório
function getOfficeName($officeId, $offices) {
    foreach ($offices as $office) {
        if ($office['id'] === $officeId) {
            return $office['name'];
        }
    }
    return 'Consultório não encontrado';
}

// Carregar pacientes e consultórios
$patients = loadPatients();
$offices = loadOffices();
$nextPatient = null;

foreach ($patients as $patient) {
    if ($patient['called'] === true && (!isset($patient['displayed']) || $patient['displayed'] === false)) {
        $nextPatient = $patient;
        
        // Marcar como já exibido
        foreach ($patients as &$p) {
            if ($p['id'] === $patient['id']) {
                $p['displayed'] = true;
                break;
            }
        }
        
        // Salvar pacientes atualizados
        file_put_contents($patients_file, json_encode($patients, JSON_PRETTY_PRINT));
        break;
    }
}

// Retornar JSON com nome do paciente e consultório
echo json_encode([
    'name' => $nextPatient 
        ? $nextPatient['name'] . ', ' . getOfficeName($nextPatient['office_id'], $offices) 
        : null
]);