<?php
require_once 'includes/config.php';
require_once 'includes/functions.php';

date_default_timezone_set('America/Sao_Paulo');

$db = Database::getInstance()->getConnection();

// Buscar últimos pacientes chamados
$stmt = $db->query("
    SELECT p.*, o.name as office_name
    FROM patients p
    LEFT JOIN offices o ON o.id = p.office_id
    WHERE p.called = 1
    AND p.displayed = 0
    ORDER BY p.called_time DESC
    LIMIT 4
");
$recent_calls = $stmt->fetchAll();

// Marcar como exibidos
if (!empty($recent_calls)) {
    $ids = array_map(function($call) {
        return $call['id'];
    }, $recent_calls);
    
    $placeholders = str_repeat('?,', count($ids) - 1) . '?';
    $stmt = $db->prepare("UPDATE patients SET displayed = 1 WHERE id IN ($placeholders)");
    $stmt->execute($ids);
}

// Buscar total de pacientes aguardando por consultório
$stmt = $db->query("
    SELECT o.name as office_name, COUNT(*) as waiting_count
    FROM patients p
    JOIN offices o ON o.id = p.office_id
    WHERE p.called = 0
    GROUP BY p.office_id, o.name
    ORDER BY o.name
");
$waiting_counts = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Painel de Chamadas</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <style>
        @keyframes blink {
            0% { opacity: 1; }
            50% { opacity: 0.5; }
            100% { opacity: 1; }
        }
        .blink {
            animation: blink 1s linear infinite;
        }
    </style>
</head>
<body class="bg-gray-900 text-white">
    <div class="container mx-auto px-4 py-8">
        <div class="text-center mb-8">
            <h1 class="text-4xl font-bold mb-2">Painel de Chamadas</h1>
            <p class="text-xl text-gray-400"><?= date('d/m/Y H:i') ?></p>
        </div>

        <div class="grid md:grid-cols-2 gap-8">
            <!-- Últimas Chamadas -->
            <div>
                <h2 class="text-2xl font-bold mb-4">Últimas Chamadas</h2>
                <div class="space-y-4">
                    <?php foreach ($recent_calls as $index => $call): ?>
                        <div class="bg-gray-800 p-6 rounded-lg <?= $index === 0 ? 'blink' : '' ?>">
                            <div class="text-2xl font-bold mb-2"><?= htmlspecialchars($call['name']) ?></div>
                            <div class="text-xl text-gray-400">
                                <?= htmlspecialchars($call['office_name']) ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <!-- Pacientes Aguardando -->
            <div>
                <h2 class="text-2xl font-bold mb-4">Pacientes Aguardando</h2>
                <div class="bg-gray-800 rounded-lg p-6">
                    <table class="w-full">
                        <thead>
                            <tr class="text-gray-400">
                                <th class="text-left py-2">Consultório</th>
                                <th class="text-right py-2">Aguardando</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($waiting_counts as $count): ?>
                                <tr class="border-t border-gray-700">
                                    <td class="py-3"><?= htmlspecialchars($count['office_name']) ?></td>
                                    <td class="py-3 text-right font-bold">
                                        <?= $count['waiting_count'] ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Atualizar a página a cada 5 segundos
        setInterval(function() {
            window.location.reload();
        }, 5000);

        // Reproduzir som quando houver nova chamada
        <?php if (!empty($recent_calls)): ?>
        const audio = new Audio('assets/sound/call.mp3');
        audio.play();
        <?php endif; ?>
    </script>
</body>
</html> 