<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';

// Verificar login
if (!isLoggedIn() || $_SESSION['user']['type'] !== 'admin') {
    header('Content-Type: application/json');
    echo json_encode(['erro' => true]);
    exit();
}

if (isset($_GET['cep'])) {
    try {
        $data = fetchCEP($_GET['cep']);
        header('Content-Type: application/json');
        echo json_encode($data);
    } catch (Exception $e) {
        header('Content-Type: application/json');
        echo json_encode(['erro' => true]);
    }
} else {
    header('Content-Type: application/json');
    echo json_encode(['erro' => true]);
} 