<?php
require_once '../config/config.php';
require_once '../config/database.php';

header('Content-Type: application/json');

try {
    $database = new Database();
    $db = $database->getConnection();

    // Debug da conexão
    if (!$db) {
        throw new PDOException("Falha na conexão com o banco de dados");
    }

    // Busca a última chamada
    $query = "SELECT 
                f.id,
                p.nome as paciente_nome,
                c.descricao as consultorio_descricao,
                u.nome as medico_nome,
                m.foto as medico_foto,
                e.nome as especialidade,
                f.called_at
              FROM fila_atendimento f
              JOIN pacientes p ON f.paciente_id = p.id
              JOIN medicos m ON f.medico_id = m.id
              JOIN usuarios u ON m.usuario_id = u.id
              JOIN consultorios c ON f.consultorio_id = c.id
              JOIN especialidades e ON m.especialidade_id = e.id
              WHERE f.status = 'chamado'
              AND DATE(f.called_at) = CURDATE()
              ORDER BY f.called_at DESC
              LIMIT 10";

    // Debug da query
    error_log("Executando query: " . $query);

    $stmt = $db->prepare($query);
    if (!$stmt->execute()) {
        $error = $stmt->errorInfo();
        throw new PDOException("Erro na execução da query: " . print_r($error, true));
    }
    
    $chamadas = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Debug
    error_log("Chamadas encontradas: " . print_r($chamadas, true));
    
    $response = [
        'nova_chamada' => isset($_SESSION['nova_chamada']) && $_SESSION['nova_chamada'],
        'chamada_atual' => empty($chamadas) ? null : $chamadas[0],
        'ultimas_chamadas' => array_slice($chamadas, 1)
    ];
    
    // Limpa a flag de nova chamada
    $_SESSION['nova_chamada'] = false;
    
    echo json_encode($response);

} catch(PDOException $e) {
    error_log("Erro no painel: " . $e->getMessage() . "\n" . $e->getTraceAsString());
    echo json_encode(['error' => true, 'message' => 'Erro ao buscar chamadas']);
    exit;
} 