<?php
require_once '../../config/config.php';
require_once '../../config/database.php';

header('Content-Type: text/event-stream');
header('Cache-Control: no-cache');
header('Connection: keep-alive');

function enviarEvento($data) {
    echo "data: " . json_encode($data) . "\n\n";
    ob_flush();
    flush();
}

try {
    $database = new Database();
    $db = $database->getConnection();
    
    $ultimoId = 0;
    
    while (true) {
        // Busca novas chamadas
        $query = "SELECT f.id, f.called_at, p.nome as nome_paciente,
                        m.nome as nome_medico, c.numero as consultorio
                 FROM fila_atendimento f
                 JOIN pacientes p ON f.paciente_id = p.id
                 JOIN medicos m ON f.medico_id = m.id
                 JOIN consultorios c ON f.consultorio_id = c.id
                 WHERE f.id > :ultimo_id AND f.status = 'chamado'
                 ORDER BY f.id DESC LIMIT 1";
                 
        $stmt = $db->prepare($query);
        $stmt->bindParam(':ultimo_id', $ultimoId);
        $stmt->execute();
        
        if ($chamada = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $ultimoId = $chamada['id'];
            enviarEvento($chamada);
        }
        
        // Evita sobrecarga do servidor
        sleep(1);
    }
    
} catch(PDOException $e) {
    handleError($e->getMessage());
    enviarEvento(['error' => 'Erro ao buscar chamadas']);
}
?> 