<?php
require_once '../../config/config.php';
require_once '../../config/database.php';

header('Content-Type: application/json');

if (!isLoggedIn() || !isMedico()) {
    echo json_encode(['success' => false, 'message' => 'Acesso não autorizado']);
    exit;
}

try {
    $database = new Database();
    $db = $database->getConnection();

    // Busca pacientes na fila do médico atual
    $query = "SELECT f.*, p.nome, p.cpf 
              FROM fila_atendimento f 
              JOIN pacientes p ON f.paciente_id = p.id 
              WHERE f.medico_id = :medico_id 
              AND f.status != 'finalizado' 
              ORDER BY f.prioridade DESC, f.created_at ASC";

    $stmt = $db->prepare($query);
    $stmt->bindParam(':medico_id', $_SESSION['user_id']);
    $stmt->execute();

    $fila = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Busca estatísticas
    $estatisticas = [
        'na_fila' => 0,
        'atendimentos_hoje' => 0,
        'tempo_medio' => 0
    ];

    // Conta pacientes na fila
    $query = "SELECT COUNT(*) as total FROM fila_atendimento 
              WHERE medico_id = :medico_id AND status != 'finalizado'";
    $stmt = $db->prepare($query);
    $stmt->bindParam(':medico_id', $_SESSION['user_id']);
    $stmt->execute();
    $estatisticas['na_fila'] = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

    // Conta atendimentos do dia
    $query = "SELECT COUNT(*) as total FROM fila_atendimento 
              WHERE medico_id = :medico_id 
              AND status = 'finalizado' 
              AND DATE(created_at) = CURDATE()";
    $stmt = $db->prepare($query);
    $stmt->bindParam(':medico_id', $_SESSION['user_id']);
    $stmt->execute();
    $estatisticas['atendimentos_hoje'] = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

    echo json_encode([
        'success' => true,
        'fila' => $fila,
        'estatisticas' => $estatisticas
    ]);

} catch(PDOException $e) {
    handleError($e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao buscar fila'
    ]);
}
?> 