<?php
require_once '../../config/config.php';
require_once '../../config/database.php';

header('Content-Type: application/json');

// Verifica se é admin
if (!isset($_SESSION['user_type']) || $_SESSION['user_type'] !== 'admin') {
    die(json_encode(['success' => false, 'message' => 'Acesso negado']));
}

$database = new Database();
$db = $database->getConnection();

// CREATE
if (isset($_POST['action']) && $_POST['action'] === 'create') {
    try {
        // Verifica se CPF já existe
        $query = "SELECT id FROM pacientes WHERE cpf = :cpf";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':cpf', $_POST['cpf']);
        $stmt->execute();
        
        if ($stmt->fetch()) {
            echo json_encode(['success' => false, 'message' => 'CPF já cadastrado']);
            exit;
        }

        $query = "INSERT INTO pacientes (
            nome, cpf, data_nascimento, sexo, email, whatsapp, 
            cep, logradouro, numero, complemento, bairro, cidade, estado, 
            observacoes, status
        ) VALUES (
            :nome, :cpf, :data_nascimento, :sexo, :email, :whatsapp,
            :cep, :logradouro, :numero, :complemento, :bairro, :cidade, :estado, 
            :observacoes, :status
        )";
        
        $stmt = $db->prepare($query);
        $stmt->bindParam(':nome', $_POST['nome']);
        $stmt->bindParam(':cpf', $_POST['cpf']);
        $stmt->bindParam(':data_nascimento', $_POST['data_nascimento']);
        $stmt->bindParam(':sexo', $_POST['sexo']);
        $stmt->bindParam(':email', $_POST['email']);
        $stmt->bindParam(':whatsapp', $_POST['whatsapp']);
        $stmt->bindParam(':cep', $_POST['cep']);
        $stmt->bindParam(':logradouro', $_POST['logradouro']);
        $stmt->bindParam(':numero', $_POST['numero']);
        $stmt->bindParam(':complemento', $_POST['complemento']);
        $stmt->bindParam(':bairro', $_POST['bairro']);
        $stmt->bindParam(':cidade', $_POST['cidade']);
        $stmt->bindParam(':estado', $_POST['estado']);
        $stmt->bindParam(':observacoes', $_POST['observacoes']);
        $stmt->bindParam(':status', $_POST['status']);
        
        $stmt->execute();
        echo json_encode(['success' => true, 'message' => 'Paciente cadastrado com sucesso']);

    } catch(PDOException $e) {
        error_log("Erro ao criar paciente: " . $e->getMessage());
        if (strpos($e->getMessage(), 'Duplicate entry') !== false) {
            echo json_encode(['success' => false, 'message' => 'CPF já cadastrado']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Erro ao cadastrar paciente']);
        }
    }
    exit;
}

// READ
if (isset($_GET['action']) && $_GET['action'] === 'read' && isset($_GET['id'])) {
    try {
        $query = "SELECT * FROM pacientes WHERE id = :id";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':id', $_GET['id']);
        $stmt->execute();
        
        $paciente = $stmt->fetch(PDO::FETCH_ASSOC);
        echo json_encode($paciente);
        
    } catch(PDOException $e) {
        error_log("Erro ao buscar paciente: " . $e->getMessage());
        echo json_encode(['success' => false, 'message' => 'Erro ao buscar paciente']);
    }
    exit;
}

// UPDATE
if (isset($_POST['action']) && $_POST['action'] === 'update') {
    try {
        $query = "UPDATE pacientes SET 
            nome = :nome,
            data_nascimento = :data_nascimento,
            sexo = :sexo,
            email = :email,
            whatsapp = :whatsapp,
            cep = :cep,
            logradouro = :logradouro,
            numero = :numero,
            complemento = :complemento,
            bairro = :bairro,
            cidade = :cidade,
            estado = :estado,
            observacoes = :observacoes,
            status = :status
            WHERE id = :id";
            
        $stmt = $db->prepare($query);
        $stmt->bindParam(':id', $_POST['id']);
        $stmt->bindParam(':nome', $_POST['nome']);
        $stmt->bindParam(':data_nascimento', $_POST['data_nascimento']);
        $stmt->bindParam(':sexo', $_POST['sexo']);
        $stmt->bindParam(':email', $_POST['email']);
        $stmt->bindParam(':whatsapp', $_POST['whatsapp']);
        $stmt->bindParam(':cep', $_POST['cep']);
        $stmt->bindParam(':logradouro', $_POST['logradouro']);
        $stmt->bindParam(':numero', $_POST['numero']);
        $stmt->bindParam(':complemento', $_POST['complemento']);
        $stmt->bindParam(':bairro', $_POST['bairro']);
        $stmt->bindParam(':cidade', $_POST['cidade']);
        $stmt->bindParam(':estado', $_POST['estado']);
        $stmt->bindParam(':observacoes', $_POST['observacoes']);
        $stmt->bindParam(':status', $_POST['status']);
        
        $stmt->execute();
        echo json_encode(['success' => true, 'message' => 'Paciente atualizado com sucesso']);

    } catch(PDOException $e) {
        error_log("Erro ao atualizar paciente: " . $e->getMessage());
        echo json_encode(['success' => false, 'message' => 'Erro ao atualizar paciente']);
    }
    exit;
}

// DELETE
if (isset($_POST['action']) && $_POST['action'] === 'delete') {
    try {
        $query = "DELETE FROM pacientes WHERE id = :id";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':id', $_POST['id']);
        $stmt->execute();
        
        echo json_encode(['success' => true, 'message' => 'Paciente excluído com sucesso']);
        
    } catch(PDOException $e) {
        error_log("Erro ao excluir paciente: " . $e->getMessage());
        echo json_encode(['success' => false, 'message' => 'Erro ao excluir paciente']);
    }
    exit;
}

// Se chegou aqui, não encontrou nenhuma ação válida
echo json_encode(['success' => false, 'message' => 'Ação inválida']); 