<?php
require_once '../../config/config.php';
require_once '../../config/database.php';

// Verifica se é admin
if (!isset($_SESSION['user_type']) || $_SESSION['user_type'] !== 'admin') {
    die(json_encode(['success' => false, 'message' => 'Acesso negado']));
}

$database = new Database();
$db = $database->getConnection();

// Função para processar upload da foto
function processarFoto($foto) {
    $upload_dir = '../../uploads/medicos/';
    if (!file_exists($upload_dir)) {
        mkdir($upload_dir, 0777, true);
    }

    $filename = uniqid() . '_' . $foto['name'];
    $upload_file = $upload_dir . $filename;

    if (move_uploaded_file($foto['tmp_name'], $upload_file)) {
        return $filename;
    }
    return false;
}

if (isset($_POST['action']) || isset($_GET['action'])) {
    
    // CREATE
    if (isset($_POST['action']) && $_POST['action'] === 'create') {
        try {
            $db->beginTransaction();

            // Processa a foto se foi enviada
            $foto = null;
            if (isset($_FILES['foto']) && $_FILES['foto']['error'] === UPLOAD_ERR_OK) {
                $foto = processarFoto($_FILES['foto']);
                if (!$foto) {
                    throw new Exception('Erro ao processar foto');
                }
            }

            // 1. Primeiro cria o usuário
            $query = "INSERT INTO usuarios (nome, login, senha, tipo) 
                     VALUES (:nome, :login, :senha, 'medico')";
            $stmt = $db->prepare($query);
            $stmt->bindParam(':nome', $_POST['nome']);
            $stmt->bindParam(':login', $_POST['login']);
            $stmt->bindParam(':senha', $_POST['senha']);
            $stmt->execute();
            
            $usuario_id = $db->lastInsertId();

            // 2. Depois cria o médico
            $query = "INSERT INTO medicos (usuario_id, especialidade_id, crm, whatsapp, consultorio_id, status, foto) 
                     VALUES (:usuario_id, :especialidade_id, :crm, :whatsapp, :consultorio_id, :status, :foto)";
            $stmt = $db->prepare($query);
            $stmt->bindParam(':usuario_id', $usuario_id);
            $stmt->bindParam(':especialidade_id', $_POST['especialidade_id']);
            $stmt->bindParam(':crm', $_POST['crm']);
            $stmt->bindParam(':whatsapp', $_POST['whatsapp']);
            $stmt->bindParam(':consultorio_id', $_POST['consultorio_id']);
            $stmt->bindParam(':status', $_POST['status']);
            $stmt->bindParam(':foto', $foto);
            $stmt->execute();

            $db->commit();
            echo json_encode(['success' => true, 'message' => 'Médico cadastrado com sucesso']);

        } catch(PDOException $e) {
            $db->rollBack();
            error_log("Erro ao criar médico: " . $e->getMessage());
            echo json_encode(['success' => false, 'message' => 'Erro ao cadastrar médico']);
        }
    }

    // READ
    if (isset($_GET['action']) && $_GET['action'] === 'read' && isset($_GET['id'])) {
        try {
            $query = "SELECT m.*, u.nome, u.login 
                     FROM medicos m 
                     JOIN usuarios u ON m.usuario_id = u.id 
                     WHERE m.id = :id";
            $stmt = $db->prepare($query);
            $stmt->bindParam(':id', $_GET['id']);
            $stmt->execute();
            
            $medico = $stmt->fetch(PDO::FETCH_ASSOC);
            echo json_encode($medico);
            
        } catch(PDOException $e) {
            error_log("Erro ao buscar médico: " . $e->getMessage());
            echo json_encode(['success' => false, 'message' => 'Erro ao buscar médico']);
        }
    }

    // UPDATE
    if (isset($_POST['action']) && $_POST['action'] === 'update') {
        try {
            $db->beginTransaction();

            // Processa nova foto se foi enviada
            if (isset($_FILES['foto']) && $_FILES['foto']['error'] === UPLOAD_ERR_OK) {
                $foto = processarFoto($_FILES['foto']);
                if ($foto) {
                    // Atualiza a foto no banco
                    $query = "UPDATE medicos SET foto = :foto WHERE id = :id";
                    $stmt = $db->prepare($query);
                    $stmt->bindParam(':foto', $foto);
                    $stmt->bindParam(':id', $_POST['id']);
                    $stmt->execute();
                }
            }

            // 1. Atualiza dados do médico
            $query = "UPDATE medicos SET 
                     especialidade_id = :especialidade_id,
                     crm = :crm,
                     whatsapp = :whatsapp,
                     consultorio_id = :consultorio_id,
                     status = :status
                     WHERE id = :id";
            
            $stmt = $db->prepare($query);
            $stmt->bindParam(':id', $_POST['id']);
            $stmt->bindParam(':especialidade_id', $_POST['especialidade_id']);
            $stmt->bindParam(':crm', $_POST['crm']);
            $stmt->bindParam(':whatsapp', $_POST['whatsapp']);
            $stmt->bindParam(':consultorio_id', $_POST['consultorio_id']);
            $stmt->bindParam(':status', $_POST['status']);
            $stmt->execute();

            // 2. Atualiza dados do usuário
            $query = "UPDATE usuarios SET 
                     nome = :nome,
                     login = :login
                     WHERE id = (SELECT usuario_id FROM medicos WHERE id = :id)";
                     
            $stmt = $db->prepare($query);
            $stmt->bindParam(':nome', $_POST['nome']);
            $stmt->bindParam(':login', $_POST['login']);
            $stmt->bindParam(':id', $_POST['id']);
            $stmt->execute();

            // 3. Atualiza senha se fornecida
            if (!empty($_POST['senha'])) {
                $query = "UPDATE usuarios SET senha = :senha 
                         WHERE id = (SELECT usuario_id FROM medicos WHERE id = :id)";
                $stmt = $db->prepare($query);
                $stmt->bindParam(':senha', $_POST['senha']);
                $stmt->bindParam(':id', $_POST['id']);
                $stmt->execute();
            }

            $db->commit();
            echo json_encode(['success' => true, 'message' => 'Médico atualizado com sucesso']);

        } catch(PDOException $e) {
            $db->rollBack();
            error_log("Erro ao atualizar médico: " . $e->getMessage());
            echo json_encode(['success' => false, 'message' => 'Erro ao atualizar médico']);
        }
    }

    // DELETE
    if (isset($_POST['action']) && $_POST['action'] === 'delete') {
        try {
            $db->beginTransaction();

            $id = $_POST['id'];

            // Pega o usuario_id antes de deletar
            $query = "SELECT usuario_id FROM medicos WHERE id = :id";
            $stmt = $db->prepare($query);
            $stmt->bindParam(':id', $id);
            $stmt->execute();
            $usuario_id = $stmt->fetch(PDO::FETCH_ASSOC)['usuario_id'];

            // Deleta o médico
            $query = "DELETE FROM medicos WHERE id = :id";
            $stmt = $db->prepare($query);
            $stmt->bindParam(':id', $id);
            $stmt->execute();

            // Deleta o usuário
            $query = "DELETE FROM usuarios WHERE id = :usuario_id";
            $stmt = $db->prepare($query);
            $stmt->bindParam(':usuario_id', $usuario_id);
            $stmt->execute();

            $db->commit();
            echo json_encode(['success' => true, 'message' => 'Médico excluído com sucesso']);

        } catch(Exception $e) {
            $db->rollBack();
            echo json_encode(['success' => false, 'message' => 'Erro ao excluir médico: ' . $e->getMessage()]);
        }
    }
} 