<?php
require_once '../config/config.php';
require_once '../config/database.php';
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Painel de Chamada</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { 
            background: #1a237e;
            color: #fff;
            overflow: hidden;
            height: 100vh;
            margin: 0;
        }
        .chamada-atual {
            background: #283593;
            padding: 20px;
            border-radius: 15px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.3);
            height: 150px;
            margin-bottom: 10px;
        }
        .chamada-atual.highlight {
            background: #3949ab;
            transform: scale(1.02);
            transition: all 0.5s ease;
        }
        .historico {
            background: #283593;
            padding: 20px;
            border-radius: 15px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.3);
            height: calc(50vh - 220px);
            overflow: hidden;
        }
        .historico-item {
            background: rgba(255,255,255,0.1);
            padding: 15px;
            margin: 10px 0;
            border-radius: 10px;
            transition: all 0.3s ease;
        }
        .historico-item:hover {
            background: rgba(255,255,255,0.15);
        }
        .medico-foto {
            width: 70px;
            height: 70px;
            border-radius: 50%;
            object-fit: cover;
            border: 3px solid #fff;
            box-shadow: 0 4px 10px rgba(0,0,0,0.3);
        }
        .medico-foto-small {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid #fff;
        }
        .paciente-nome {
            font-size: 36px;
            font-weight: bold;
            margin: 0;
            color: #fff;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.2);
        }
        .consultorio {
            font-size: 28px;
            color: #fff;
            margin-top: 5px;
        }
        .medico-info {
            text-align: center;
        }
        .medico-nome {
            font-size: 24px;
            color: #fff;
        }
        .especialidade {
            font-size: 24px;
            color: rgba(255,255,255,0.8);
        }
        .titulo-secao {
            font-size: 24px;
            margin-bottom: 15px;
        }
        .historico-scroll {
            height: calc(100% - 40px);
            overflow-y: auto;
            scrollbar-width: thin;
            scrollbar-color: rgba(255,255,255,0.5) transparent;
        }
        .historico-scroll::-webkit-scrollbar {
            width: 8px;
        }
        .historico-scroll::-webkit-scrollbar-track {
            background: transparent;
        }
        .historico-scroll::-webkit-scrollbar-thumb {
            background-color: rgba(255,255,255,0.5);
            border-radius: 4px;
        }
        .slider-container {
            background: #283593;
            padding: 20px;
            border-radius: 15px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.3);
            height: 100%;
        }
        .slider-img {
            border-radius: 10px;
            height: calc(45vh - 40px);
            width: 100%;
            object-fit: cover;
        }
        .carousel-item {
            transition: opacity 0.8s ease-in-out;
        }
        .carousel-fade .carousel-item {
            opacity: 0;
            transition: opacity 0.8s ease-in-out;
        }
        .carousel-fade .carousel-item.active {
            opacity: 1;
        }
        .no-image {
            height: 360px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 24px;
            background: rgba(255,255,255,0.1);
            border-radius: 10px;
        }
        .container-fluid {
            height: 100vh;
            padding: 20px;
            display: flex;
            flex-direction: column;
        }
        .slider-area {
            height: 45vh;
            margin-bottom: 20px;
        }
        .info-area {
            flex: 1;
            display: flex;
            flex-direction: column;
            gap: 20px;
            height: calc(50vh - 40px);
        }
        .medico-container {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }
        @media (max-width: 768px) {
            .slider-container {
                height: 300px;
            }
            .slider-img, .no-image {
                height: 260px;
            }
        }
        .row {
            margin: 0;
        }
        .col-12 {
            padding: 0;
        }
    </style>
</head>
<body>

<div class="container-fluid">
    <!-- Slider no topo -->
    <div class="slider-area">
        <div class="slider-container">
            <div id="imageSlider" class="carousel slide carousel-fade" data-bs-ride="carousel" data-bs-interval="10000">
                <div class="carousel-inner">
                    <?php
                    // Pasta das imagens
                    $pasta_imagens = '../assets/img/clinica/';
                    $extensoes = ['jpg', 'jpeg', 'png'];
                    
                    $imagens = [];
                    foreach ($extensoes as $ext) {
                        $imagens = array_merge($imagens, glob($pasta_imagens . "*." . $ext));
                    }
                    
                    if (empty($imagens)) {
                        echo "<div class='carousel-item active'>";
                        echo "<div class='no-image'>Nenhuma imagem encontrada</div>";
                        echo "</div>";
                    } else {
                        foreach ($imagens as $index => $imagem) {
                            $active = $index === 0 ? 'active' : '';
                            $imagem_url = str_replace('../', BASE_URL . '/', $imagem);
                            echo "<div class='carousel-item $active'>";
                            echo "<img src='$imagem_url' class='d-block w-100 slider-img' alt='Imagem da Clínica'>";
                            echo "</div>";
                        }
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Área de informações -->
    <div class="info-area">
        <!-- Chamada Atual -->
        <div class="chamada-atual" id="chamada-atual">
            <!-- Preenchido via JavaScript -->
        </div>

        <!-- Histórico de Chamadas -->
        <div class="historico">
            <h2 class="titulo-secao">Últimas Chamadas</h2>
            <div class="historico-scroll" id="historico-chamadas">
                <!-- Preenchido via JavaScript -->
            </div>
        </div>
    </div>
</div>

<audio id="audio-chamada">
    <source src="<?php echo BASE_URL; ?>/assets/sounds/chamada.mp3" type="audio/mpeg">
</audio>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
const BASE_URL = '<?php echo BASE_URL; ?>';
let audioInitialized = false;

function falarChamada(paciente, consultorio) {
    const texto = `Paciente ${paciente}, ${consultorio}`;
    const utterance = new SpeechSynthesisUtterance(texto);
    utterance.lang = 'pt-BR';
    utterance.rate = 0.9;
    utterance.pitch = 1;
    speechSynthesis.speak(utterance);
}

function tocarSomEFalar(paciente, consultorio) {
    if (!audioInitialized) {
        // Se o áudio não foi inicializado, só fala
        falarChamada(paciente, consultorio);
        return;
    }
    
    const audio = document.getElementById('audio-chamada');
    audio.play().then(() => {
        audio.onended = function() {
            falarChamada(paciente, consultorio);
        };
    }).catch(() => {
        // Se falhar ao tocar o som, pelo menos fala
        falarChamada(paciente, consultorio);
    });
}

function atualizarPainel() {
    fetch(`${BASE_URL}/src/painel.php`)
        .then(response => response.json())
        .then(data => {
            if (data.nova_chamada && data.chamada_atual) {
                const chamada = data.chamada_atual;
                
                // Atualiza chamada atual
                document.getElementById('chamada-atual').innerHTML = `
                    <div class="row align-items-center text-center">
                        <div class="col-md-4">
                            <div class="paciente-nome">${chamada.paciente_nome}</div>
                        </div>
                        <div class="col-md-4">
                            <div class="consultorio">${chamada.consultorio_descricao}</div>
                        </div>
                        <div class="col-md-4">
                            <div class="medico-container">
                                <img src="${BASE_URL}/uploads/medicos/${chamada.medico_foto}" 
                                     class="medico-foto" 
                                     alt="Dr(a). ${chamada.medico_nome}"
                                     onerror="this.src='${BASE_URL}/assets/img/no-image.jpg'">
                                <div class="medico-nome">Dr(a). ${chamada.medico_nome}</div>
                                <div class="especialidade">${chamada.especialidade}</div>
                            </div>
                        </div>
                    </div>
                `;

                // Efeito visual
                const elemento = document.getElementById('chamada-atual');
                elemento.classList.add('highlight');
                setTimeout(() => elemento.classList.remove('highlight'), 2000);

                // Toca o som e depois fala
                const audio = document.getElementById('audio-chamada');
                audio.play();
                audio.onended = () => {
                    falarChamada(chamada.paciente_nome, chamada.consultorio_descricao);
                };

                // Atualiza histórico
                const historicoChamadas = document.getElementById('historico-chamadas');
                const div = document.createElement('div');
                div.className = 'historico-item';
                div.innerHTML = `
                    <div class="row align-items-center">
                        <div class="col-md-4">
                            <div class="h5 mb-0">${chamada.paciente_nome}</div>
                        </div>
                        <div class="col-md-4">
                            <div class="h6 mb-0">${chamada.consultorio_descricao}</div>
                        </div>
                        <div class="col-md-4">
                            <div class="medico-container">
                                <img src="${BASE_URL}/uploads/medicos/${chamada.medico_foto}" 
                                     class="medico-foto" 
                                     alt="Dr(a). ${chamada.medico_nome}"
                                     onerror="this.src='${BASE_URL}/assets/img/no-image.jpg'">
                                <div>
                                    <div class="medico-nome">Dr(a). ${chamada.medico_nome}</div>
                                    <div class="especialidade">${chamada.especialidade}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                `;
                historicoChamadas.insertBefore(div, historicoChamadas.firstChild);
            }
            else if (data.chamada_atual) {
                // Apenas atualiza a chamada atual sem som/fala
                document.getElementById('chamada-atual').innerHTML = `
                    <div class="row align-items-center text-center">
                        <div class="col-md-4">
                            <div class="paciente-nome">${data.chamada_atual.paciente_nome}</div>
                        </div>
                        <div class="col-md-4">
                            <div class="consultorio">${data.chamada_atual.consultorio_descricao}</div>
                        </div>
                        <div class="col-md-4">
                            <div class="medico-container">
                                <img src="${BASE_URL}/uploads/medicos/${data.chamada_atual.medico_foto}" 
                                     class="medico-foto" 
                                     alt="Dr(a). ${data.chamada_atual.medico_nome}"
                                     onerror="this.src='${BASE_URL}/assets/img/no-image.jpg'">
                                <div class="medico-nome">Dr(a). ${data.chamada_atual.medico_nome}</div>
                                <div class="especialidade">${data.chamada_atual.especialidade}</div>
                            </div>
                        </div>
                    </div>
                `;
            }
        });
}

// Atualiza a cada 2 segundos
setInterval(atualizarPainel, 2000);

// Primeira atualização
atualizarPainel();

// Adiciona interação inicial para permitir sons
document.addEventListener('click', function() {
    const audio = document.getElementById('audio-chamada');
    audio.play().then(() => {
        audio.pause();
        audio.currentTime = 0;
        audioInitialized = true;
    }).catch(e => console.log('Erro ao inicializar áudio:', e));
}, { once: true });
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>