<?php
require_once '../../config/config.php';
require_once '../../includes/auth_medico.php';
require_once '../../includes/header.php';

// Busca dados do médico e sua fila
$database = new Database();
$db = $database->getConnection();

// Busca fila de atendimento do médico
$query = "SELECT f.*, p.nome as paciente_nome, p.cpf, c.numero as consultorio_numero 
          FROM fila_atendimento f
          JOIN pacientes p ON f.paciente_id = p.id
          JOIN consultorios c ON f.consultorio_id = c.id
          WHERE f.medico_id = :medico_id 
          AND f.status IN ('aguardando', 'chamado')
          ORDER BY f.prioridade DESC, f.created_at ASC";

$stmt = $db->prepare($query);
$stmt->bindParam(':medico_id', $_SESSION['medico_id']);
$stmt->execute();
$fila = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container mt-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5>Fila de Atendimento</h5>
                </div>
                <div class="card-body">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Paciente</th>
                                <th>CPF</th>
                                <th>Consultório</th>
                                <th>Horário</th>
                                <th>Status</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($fila)): ?>
                                <tr>
                                    <td colspan="6" class="text-center">Nenhum paciente na fila</td>
                                </tr>
                            <?php else: ?>
                                <?php foreach ($fila as $atendimento): ?>
                                    <tr>
                                        <td><?php echo $atendimento['paciente_nome']; ?></td>
                                        <td><?php echo $atendimento['cpf']; ?></td>
                                        <td><?php echo $atendimento['consultorio_numero']; ?></td>
                                        <td><?php echo date('H:i', strtotime($atendimento['created_at'])); ?></td>
                                        <td>
                                            <span class="badge bg-<?php echo $atendimento['status'] === 'aguardando' ? 'warning' : 'info'; ?>">
                                                <?php echo ucfirst($atendimento['status']); ?>
                                            </span>
                                        </td>
                                        <td>
                                            <?php if ($atendimento['status'] === 'aguardando'): ?>
                                                <button class="btn btn-sm btn-primary" 
                                                        onclick="chamarPaciente(<?php echo $atendimento['id']; ?>)">
                                                    Chamar
                                                </button>
                                            <?php else: ?>
                                                <button class="btn btn-sm btn-success" 
                                                        onclick="iniciarAtendimento(<?php echo $atendimento['id']; ?>)">
                                                    Iniciar
                                                </button>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function chamarPaciente(id) {
    if (confirm('Deseja chamar este paciente?')) {
        fetch(`${BASE_URL}/src/medico/atendimento.php`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({
                action: 'chamar',
                id: id
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message);
            }
        });
    }
}

function iniciarAtendimento(id) {
    if (confirm('Iniciar atendimento deste paciente?')) {
        fetch(`${BASE_URL}/src/medico/atendimento.php`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({
                action: 'iniciar',
                id: id
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message);
            }
        });
    }
}
</script>

<?php require_once '../../includes/footer.php'; ?> 