<?php
require_once '../../config/config.php';
require_once '../../includes/auth_admin.php';
require_once '../../includes/header.php';

$database = new Database();
$db = $database->getConnection();

// Busca pacientes
$query = "SELECT * FROM pacientes ORDER BY nome";
$stmt = $db->prepare($query);
$stmt->execute();
$pacientes = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container mt-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="float-start">Pacientes</h5>
                    <button class="btn btn-primary float-end" data-bs-toggle="modal" data-bs-target="#addPacienteModal">
                        Novo Paciente
                    </button>
                </div>
                <div class="card-body">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Nome</th>
                                <th>CPF</th>
                                <th>WhatsApp</th>
                                <th>Status</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($pacientes)): ?>
                                <tr>
                                    <td colspan="5" class="text-center">Nenhum paciente cadastrado</td>
                                </tr>
                            <?php else: ?>
                                <?php foreach ($pacientes as $pac): ?>
                                    <tr>
                                        <td><?php echo $pac['nome']; ?></td>
                                        <td><?php echo $pac['cpf']; ?></td>
                                        <td><?php echo $pac['whatsapp']; ?></td>
                                        <td>
                                            <span class="badge bg-<?php echo $pac['status'] === 'ativo' ? 'success' : 'danger'; ?>">
                                                <?php echo ucfirst($pac['status']); ?>
                                            </span>
                                        </td>
                                        <td>
                                            <button class="btn btn-sm btn-info" onclick="editarPaciente(<?php echo $pac['id']; ?>)">
                                                Editar
                                            </button>
                                            <button class="btn btn-sm btn-danger" onclick="excluirPaciente(<?php echo $pac['id']; ?>)">
                                                Excluir
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal Paciente -->
<div class="modal fade" id="addPacienteModal">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Novo Paciente</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="formPaciente">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Nome *</label>
                            <input type="text" class="form-control" name="nome" required tabindex="1">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">CPF *</label>
                            <input type="text" class="form-control" name="cpf" id="cpf" required tabindex="2">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">WhatsApp *</label>
                            <input type="text" class="form-control" name="whatsapp" id="whatsapp" required tabindex="3">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">E-mail</label>
                            <input type="email" class="form-control" name="email" tabindex="4">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Sexo *</label>
                            <select class="form-control" name="sexo" required tabindex="5">
                                <option value="">Selecione...</option>
                                <option value="M">Masculino</option>
                                <option value="F">Feminino</option>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Status</label>
                            <select class="form-control" name="status" tabindex="6">
                                <option value="ativo">Ativo</option>
                                <option value="inativo">Inativo</option>
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Data de Nascimento *</label>
                            <input type="date" class="form-control" name="data_nascimento" required tabindex="7">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">CEP</label>
                            <input type="text" class="form-control" name="cep" id="cep" tabindex="8">
                        </div>
                    </div>
                    <div id="endereco">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Logradouro</label>
                                <input type="text" class="form-control" name="logradouro" tabindex="9">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Número</label>
                                <input type="text" class="form-control" name="numero" tabindex="10">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Bairro</label>
                                <input type="text" class="form-control" name="bairro" tabindex="11">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Complemento</label>
                                <input type="text" class="form-control" name="complemento" tabindex="12">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Cidade</label>
                                <input type="text" class="form-control" name="cidade" tabindex="13">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Estado</label>
                                <input type="text" class="form-control" name="estado" tabindex="14">
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Observações</label>
                        <textarea class="form-control" name="observacoes" rows="3" tabindex="15"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Salvar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php require_once '../../includes/footer.php'; ?>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/jquery-mask-plugin@1.14.16/dist/jquery.mask.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script>

<script>
const BASE_URL = '<?php echo BASE_URL; ?>';

// Máscaras
$(document).ready(function(){
    // Aplica máscara no CPF
    $('#cpf').mask('000.000.000-00');
    
    // Aplica máscara no WhatsApp
    $('#whatsapp').mask('(00) 00000-0000');
    
    // Aplica máscara no CEP
    $('#cep').mask('00000-000');
});

// Validação de CPF
function validaCPF(cpf) {
    cpf = cpf.replace(/[^\d]+/g,'');
    if(cpf == '') return false;
    if (cpf.length != 11 || 
        cpf == "00000000000" || 
        cpf == "11111111111" || 
        cpf == "22222222222" || 
        cpf == "33333333333" || 
        cpf == "44444444444" || 
        cpf == "55555555555" || 
        cpf == "66666666666" || 
        cpf == "77777777777" || 
        cpf == "88888888888" || 
        cpf == "99999999999")
        return false;
    add = 0;
    for (i=0; i < 9; i ++)
        add += parseInt(cpf.charAt(i)) * (10 - i);
    rev = 11 - (add % 11);
    if (rev == 10 || rev == 11)
        rev = 0;
    if (rev != parseInt(cpf.charAt(9)))
        return false;
    add = 0;
    for (i = 0; i < 10; i ++)
        add += parseInt(cpf.charAt(i)) * (11 - i);
    rev = 11 - (add % 11);
    if (rev == 10 || rev == 11)
        rev = 0;
    if (rev != parseInt(cpf.charAt(10)))
        return false;
    return true;
}

// Busca CEP automática
$('#cep').on('keyup blur', function() {
    const cep = $(this).val().replace(/\D/g, '');
    
    if (cep.length === 8) {
        fetch(`https://viacep.com.br/ws/${cep}/json/`)
            .then(response => response.json())
            .then(data => {
                if (!data.erro) {
                    $('input[name="logradouro"]').val(data.logradouro);
                    $('input[name="bairro"]').val(data.bairro);
                    $('input[name="cidade"]').val(data.localidade);
                    $('input[name="estado"]').val(data.uf);
                    $('input[name="numero"]').focus();
                } else {
                    // Limpa os campos se o CEP não for encontrado
                    $('input[name="logradouro"]').val('');
                    $('input[name="bairro"]').val('');
                    $('input[name="cidade"]').val('');
                    $('input[name="estado"]').val('');
                }
            })
            .catch(error => {
                console.error('Erro:', error);
            });
    }
});

// Validação do formulário
$('#formPaciente').on('submit', function(e) {
    e.preventDefault();
    
    const cpf = $('#cpf').val();
    if (!validaCPF(cpf)) {
        alert('CPF inválido');
        return;
    }

    const formData = new FormData(this);
    formData.append('action', $(this).data('id') ? 'update' : 'create');
    if ($(this).data('id')) {
        formData.append('id', $(this).data('id'));
    }

    fetch(`${BASE_URL}/src/admin/paciente.php`, {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        } else {
            alert(data.message);
        }
    });
});

// Quando abrir o modal
$('#addPacienteModal').on('show.bs.modal', function (event) {
    const button = $(event.relatedTarget);
    
    // Se NÃO for o botão de editar
    if (button.length > 0) {
        // Limpa o formulário
        $('#formPaciente').trigger('reset');
        $('#formPaciente').removeData('id');
        $('.modal-title').text('Novo Paciente');
        $('#formPaciente input[name="cpf"]').prop('readonly', false);
    }
});

// Função para editar paciente
function editarPaciente(id) {
    fetch(`${BASE_URL}/src/admin/paciente.php?action=read&id=${id}`)
        .then(response => response.json())
        .then(data => {
            // Muda o título
            $('.modal-title').text('Editar Paciente');
            
            // Preenche os campos
            $('#formPaciente input[name="nome"]').val(data.nome);
            $('#formPaciente input[name="cpf"]').val(data.cpf);
            $('#formPaciente input[name="data_nascimento"]').val(data.data_nascimento);
            $('#formPaciente select[name="sexo"]').val(data.sexo);
            $('#formPaciente input[name="email"]').val(data.email);
            $('#formPaciente input[name="whatsapp"]').val(data.whatsapp);
            $('#formPaciente input[name="cep"]').val(data.cep);
            $('#formPaciente input[name="logradouro"]').val(data.logradouro);
            $('#formPaciente input[name="numero"]').val(data.numero);
            $('#formPaciente input[name="complemento"]').val(data.complemento);
            $('#formPaciente input[name="bairro"]').val(data.bairro);
            $('#formPaciente input[name="cidade"]').val(data.cidade);
            $('#formPaciente input[name="estado"]').val(data.estado);
            $('#formPaciente textarea[name="observacoes"]').val(data.observacoes);
            $('#formPaciente select[name="status"]').val(data.status);
            
            // Guarda o ID para edição
            $('#formPaciente').data('id', id);
            
            // CPF não pode ser editado
            $('#formPaciente input[name="cpf"]').prop('readonly', true);
            
            // Abre o modal
            new bootstrap.Modal(document.getElementById('addPacienteModal')).show();
        });
}

// Função para excluir paciente
function excluirPaciente(id) {
    if (confirm('Tem certeza que deseja excluir este paciente?')) {
        const formData = new FormData();
        formData.append('action', 'delete');
        formData.append('id', id);

        fetch(`${BASE_URL}/src/admin/paciente.php`, {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message);
            }
        });
    }
}
</script> 