<?php
require_once '../../config/config.php';
require_once '../../includes/auth_admin.php';
require_once '../../includes/header.php';

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

try {
    $database = new Database();
    $db = $database->getConnection();

    // Query mais simples para teste
    $query = "SELECT COUNT(*) as total FROM fila_atendimento";
    $stmt = $db->prepare($query);
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo "<!-- Total de registros: " . $result['total'] . " -->";

    // Agora a query completa
    $query = "SELECT 
                f.id, 
                f.tipo_atendimento, 
                f.prioridade, 
                f.status, 
                p.nome as paciente_nome, 
                p.cpf,
                u.nome as medico_nome,
                c.descricao as consultorio_nome
              FROM fila_atendimento f
              JOIN pacientes p ON f.paciente_id = p.id
              JOIN medicos m ON f.medico_id = m.id
              JOIN usuarios u ON m.usuario_id = u.id
              JOIN consultorios c ON f.consultorio_id = c.id
              WHERE f.status IN ('aguardando', 'chamado')
              ORDER BY f.id DESC";

    $stmt = $db->prepare($query);
    $stmt->execute();
    $fila = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (Exception $e) {
    echo "<!-- Erro: " . $e->getMessage() . " -->";
    echo "<!-- Arquivo: " . $e->getFile() . " -->";
    echo "<!-- Linha: " . $e->getLine() . " -->";
    die("Erro ao carregar a fila. Por favor, contate o administrador.");
}
?>

<div class="container mt-4">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Fila de Atendimento</h5>
            <a href="recepcao.php" class="btn btn-primary">Adicionar Paciente</a>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Paciente</th>
                            <th>CPF</th>
                            <th>Médico</th>
                            <th>Consultório</th>
                            <th>Tipo</th>
                            <th>Prioridade</th>
                            <th>Status</th>
                            <th>Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($fila)): ?>
                            <tr>
                                <td colspan="8" class="text-center">Nenhum paciente na fila</td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($fila as $atendimento): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($atendimento['paciente_nome']); ?></td>
                                    <td><?php echo htmlspecialchars($atendimento['cpf']); ?></td>
                                    <td><?php echo htmlspecialchars($atendimento['medico_nome']); ?></td>
                                    <td><?php echo htmlspecialchars($atendimento['consultorio_nome']); ?></td>
                                    <td><?php echo ucfirst($atendimento['tipo_atendimento']); ?></td>
                                    <td><?php echo ucfirst($atendimento['prioridade']); ?></td>
                                    <td><?php echo ucfirst($atendimento['status']); ?></td>
                                    <td>
                                        <button class="btn btn-sm btn-info" onclick="editarPacienteFila(<?php echo $atendimento['id']; ?>)">
                                            Editar
                                        </button>
                                        <button class="btn btn-sm btn-warning" onclick="chamarPaciente(<?php echo $atendimento['id']; ?>)">
                                            Chamar
                                        </button>
                                        <button class="btn btn-sm btn-danger" onclick="removerDaFila(<?php echo $atendimento['id']; ?>)">
                                            Remover
                                        </button>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Modal de Edição -->
<div class="modal fade" id="editarFilaModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Editar Paciente na Fila</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="formEditarFila">
                    <input type="hidden" name="id" id="edit_id">
                    
                    <div class="mb-3">
                        <label class="form-label">Tipo de Atendimento</label>
                        <select class="form-control" name="tipo_atendimento" id="edit_tipo_atendimento" required>
                            <option value="normal">Normal</option>
                            <option value="agendado">Agendado</option>
                        </select>
                    </div>

                    <div class="mb-3" id="div_horario_agendado" style="display:none;">
                        <label class="form-label">Horário Agendado</label>
                        <input type="time" class="form-control" name="horario_agendado" id="edit_horario_agendado">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Prioridade</label>
                        <select class="form-control" name="prioridade" id="edit_prioridade" required>
                            <option value="normal">Normal</option>
                            <option value="idoso">Idoso</option>
                            <option value="gestante">Gestante</option>
                            <option value="pcd">PCD</option>
                            <option value="urgencia">Urgência</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Observações</label>
                        <textarea class="form-control" name="observacoes" id="edit_observacoes" rows="2"></textarea>
                    </div>

                    <button type="submit" class="btn btn-primary">Salvar</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
const BASE_URL = '<?php echo BASE_URL; ?>';

function chamarPaciente(id) {
    if (confirm('Confirma chamar o paciente?')) {
        fetch(`${BASE_URL}/src/admin/fila.php`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: `action=chamar&id=${id}`
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message);
            }
        });
    }
}

function removerDaFila(id) {
    if (confirm('Confirma remover o paciente da fila?')) {
        fetch(`${BASE_URL}/src/admin/fila.php`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: `action=remover&id=${id}`
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message);
            }
        });
    }
}

function editarPacienteFila(id) {
    fetch(`${BASE_URL}/src/admin/fila.php?action=buscar&id=${id}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const paciente = data.paciente;
                $('#edit_id').val(paciente.id);
                $('#edit_tipo_atendimento').val(paciente.tipo_atendimento);
                $('#edit_horario_agendado').val(paciente.horario_agendado);
                $('#edit_prioridade').val(paciente.prioridade);
                $('#edit_observacoes').val(paciente.observacoes);
                
                toggleHorarioAgendado(paciente.tipo_atendimento);
                
                new bootstrap.Modal(document.getElementById('editarFilaModal')).show();
            } else {
                alert(data.message);
            }
        });
}

function toggleHorarioAgendado(tipo) {
    $('#div_horario_agendado').toggle(tipo === 'agendado');
    $('#edit_horario_agendado').prop('required', tipo === 'agendado');
}

$('#formEditarFila').on('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    formData.append('action', 'editar');

    fetch(`${BASE_URL}/src/admin/fila.php`, {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        } else {
            alert(data.message);
        }
    });
});
</script>

<?php require_once '../../includes/footer.php'; ?> 