<?php
require_once '../../config/config.php';
require_once '../../includes/auth_admin.php';
require_once '../../includes/header.php';

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

try {
    $database = new Database();
    $db = $database->getConnection();

    // Query mais simples para teste
    $query = "SELECT COUNT(*) as total FROM fila_atendimento";
    $stmt = $db->prepare($query);
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo "<!-- Total de registros: " . $result['total'] . " -->";

    // Agora a query completa
    $query = "SELECT 
                f.id, 
                f.tipo_atendimento, 
                f.prioridade, 
                f.status, 
                p.nome as paciente_nome, 
                p.cpf,
                u.nome as medico_nome,
                c.descricao as consultorio_nome
              FROM fila_atendimento f
              JOIN pacientes p ON f.paciente_id = p.id
              JOIN medicos m ON f.medico_id = m.id
              JOIN usuarios u ON m.usuario_id = u.id
              JOIN consultorios c ON f.consultorio_id = c.id
              WHERE f.status IN ('aguardando', 'chamado')
              ORDER BY f.id DESC";

    echo "<!-- Query: " . $query . " -->";
    
    $stmt = $db->prepare($query);
    $stmt->execute();
    
    echo "<!-- Número de registros: " . $stmt->rowCount() . " -->";
    
    $fila = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<!-- Dados: " . print_r($fila, true) . " -->";

} catch (Exception $e) {
    echo "<!-- Erro: " . $e->getMessage() . " -->";
    echo "<!-- Arquivo: " . $e->getFile() . " -->";
    echo "<!-- Linha: " . $e->getLine() . " -->";
    die("Erro ao carregar a fila. Por favor, contate o administrador.");
}
?>

<div class="container mt-4">
    <ul class="nav nav-tabs mb-4">
        <li class="nav-item">
            <a class="nav-link active" data-bs-toggle="tab" href="#aguardando">Aguardando</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" data-bs-toggle="tab" href="#chamados">Chamados</a>
        </li>
    </ul>

    <div class="tab-content">
        <!-- Aba Aguardando -->
        <div class="tab-pane fade show active" id="aguardando">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Fila de Atendimento</h5>
                    <a href="recepcao.php" class="btn btn-primary">Adicionar Paciente</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Paciente</th>
                                    <th>CPF</th>
                                    <th>Médico</th>
                                    <th>Consultório</th>
                                    <th>Tipo</th>
                                    <th>Prioridade</th>
                                    <th>Status</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($fila)): ?>
                                    <tr>
                                        <td colspan="8" class="text-center">Nenhum paciente na fila</td>
                                    </tr>
                                <?php else: ?>
                                    <?php 
                                    $fila_aguardando = array_filter($fila, function($a) { 
                                        return $a['status'] === 'aguardando'; 
                                    });
                                    if (empty($fila_aguardando)): 
                                    ?>
                                        <tr>
                                            <td colspan="8" class="text-center">Nenhum paciente aguardando</td>
                                        </tr>
                                    <?php else: ?>
                                        <?php foreach ($fila_aguardando as $atendimento): ?>
                                            <tr>
                                                <td><?php echo htmlspecialchars($atendimento['paciente_nome']); ?></td>
                                                <td><?php echo htmlspecialchars($atendimento['cpf']); ?></td>
                                                <td><?php echo htmlspecialchars($atendimento['medico_nome']); ?></td>
                                                <td><?php echo htmlspecialchars($atendimento['consultorio_nome']); ?></td>
                                                <td><?php echo ucfirst($atendimento['tipo_atendimento']); ?></td>
                                                <td>
                                                    <span class="badge bg-<?php 
                                                        if ($atendimento['prioridade'] === 'urgencia') {
                                                            echo 'danger';
                                                        } elseif ($atendimento['prioridade'] === 'normal') {
                                                            echo 'success';
                                                        } else {
                                                            echo 'warning';
                                                        }
                                                    ?>">
                                                        <?php echo ucfirst($atendimento['prioridade']); ?>
                                                    </span>
                                                </td>
                                                <td><?php echo ucfirst($atendimento['status']); ?></td>
                                                <td>
                                                    <button class="btn btn-sm btn-info" onclick="editarPacienteFila(<?php echo $atendimento['id']; ?>)">
                                                        Editar
                                                    </button>
                                                    <button class="btn btn-sm btn-warning" onclick="chamarPaciente(<?php echo $atendimento['id']; ?>)">
                                                        Chamar
                                                    </button>
                                                    <button class="btn btn-sm btn-danger" onclick="removerDaFila(<?php echo $atendimento['id']; ?>)">
                                                        Remover
                                                    </button>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Aba Chamados -->
        <div class="tab-pane fade" id="chamados">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Pacientes Chamados</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Paciente</th>
                                    <th>CPF</th>
                                    <th>Médico</th>
                                    <th>Consultório</th>
                                    <th>Tipo</th>
                                    <th>Prioridade</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $fila_chamados = array_filter($fila, function($a) { 
                                    return $a['status'] === 'chamado'; 
                                });
                                if (empty($fila_chamados)): 
                                ?>
                                    <tr>
                                        <td colspan="7" class="text-center">Nenhum paciente chamado</td>
                                    </tr>
                                <?php else: ?>
                                    <?php foreach ($fila_chamados as $atendimento): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($atendimento['paciente_nome']); ?></td>
                                            <td><?php echo htmlspecialchars($atendimento['cpf']); ?></td>
                                            <td><?php echo htmlspecialchars($atendimento['medico_nome']); ?></td>
                                            <td><?php echo htmlspecialchars($atendimento['consultorio_nome']); ?></td>
                                            <td><?php echo ucfirst($atendimento['tipo_atendimento']); ?></td>
                                            <td>
                                                <span class="badge bg-<?php 
                                                    if ($atendimento['prioridade'] === 'urgencia') {
                                                        echo 'danger';
                                                    } elseif ($atendimento['prioridade'] === 'normal') {
                                                        echo 'success';
                                                    } else {
                                                        echo 'warning';
                                                    }
                                                ?>">
                                                    <?php echo ucfirst($atendimento['prioridade']); ?>
                                                </span>
                                            </td>
                                            <td>
                                                <button class="btn btn-sm btn-warning" onclick="chamarPaciente(<?php echo $atendimento['id']; ?>)">
                                                    Chamar Novamente
                                                </button>
                                                <button class="btn btn-sm btn-danger" onclick="removerDaFila(<?php echo $atendimento['id']; ?>)">
                                                    Remover
                                                </button>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal de Edição -->
<div class="modal fade" id="editarFilaModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Editar Paciente na Fila</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="formEditarFila">
                    <input type="hidden" name="id" id="edit_id">
                    
                    <div class="mb-3">
                        <label class="form-label">Tipo de Atendimento</label>
                        <select class="form-control" name="tipo_atendimento" id="edit_tipo_atendimento" required>
                            <option value="normal">Normal</option>
                            <option value="agendado">Agendado</option>
                        </select>
                    </div>

                    <div class="mb-3" id="div_horario_agendado" style="display:none;">
                        <label class="form-label">Horário Agendado</label>
                        <input type="time" class="form-control" name="horario_agendado" id="edit_horario_agendado">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Prioridade</label>
                        <select class="form-control" name="prioridade" id="edit_prioridade" required>
                            <option value="normal">Normal</option>
                            <option value="idoso">Idoso</option>
                            <option value="gestante">Gestante</option>
                            <option value="pcd">PCD</option>
                            <option value="urgencia">Urgência</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Observações</label>
                        <textarea class="form-control" name="observacoes" id="edit_observacoes" rows="2"></textarea>
                    </div>

                    <button type="submit" class="btn btn-primary">Salvar</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Antes do script atual -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<!-- Seu script atual -->
<script>
const BASE_URL = '<?php echo BASE_URL; ?>';

function chamarPaciente(id) {
    if (confirm('Confirma chamar o paciente?')) {
        fetch(`${BASE_URL}/src/admin/fila.php`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: `action=chamar&id=${id}`
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message);
            }
        });
    }
}

function removerDaFila(id) {
    if (confirm('Confirma remover o paciente da fila?')) {
        fetch(`${BASE_URL}/src/admin/fila.php`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: `action=remover&id=${id}`
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message);
            }
        });
    }
}

function editarPacienteFila(id) {
    console.log('Editando paciente:', id); // Debug

    fetch(`${BASE_URL}/src/admin/fila.php?action=buscar&id=${id}`)
        .then(response => response.json())
        .then(data => {
            console.log('Dados recebidos:', data); // Debug
            if (data.success) {
                const paciente = data.paciente;
                $('#edit_id').val(paciente.id);
                $('#edit_tipo_atendimento').val(paciente.tipo_atendimento);
                $('#edit_horario_agendado').val(paciente.horario_agendado);
                $('#edit_prioridade').val(paciente.prioridade);
                $('#edit_observacoes').val(paciente.observacoes);
                
                toggleHorarioAgendado(paciente.tipo_atendimento);
                
                new bootstrap.Modal(document.getElementById('editarFilaModal')).show();
            } else {
                alert(data.message || 'Erro ao carregar dados do paciente');
            }
        })
        .catch(error => {
            console.error('Erro:', error);
            alert('Erro ao carregar dados do paciente');
        });
}

function toggleHorarioAgendado(tipo) {
    $('#div_horario_agendado').toggle(tipo === 'agendado');
    $('#edit_horario_agendado').prop('required', tipo === 'agendado');
}

$('#formEditarFila').on('submit', function(e) {
    e.preventDefault();
    
    // Converte o formulário para URLSearchParams
    const data = {
        action: 'editar',
        id: $('#edit_id').val(),
        tipo_atendimento: $('#edit_tipo_atendimento').val(),
        horario_agendado: $('#edit_horario_agendado').val(),
        prioridade: $('#edit_prioridade').val(),
        observacoes: $('#edit_observacoes').val()
    };

    // Debug
    console.log('Dados sendo enviados:', data);

    fetch(`${BASE_URL}/src/admin/fila.php`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: new URLSearchParams(data).toString()
    })
    .then(response => response.json())
    .then(data => {
        console.log('Resposta:', data); // Debug
        if (data.success) {
            alert('Salvo com sucesso!');
            location.reload();
        } else {
            alert(data.message || 'Erro ao salvar alterações');
        }
    })
    .catch(error => {
        console.error('Erro:', error);
        alert('Erro ao salvar alterações');
    });
});
</script>

<?php require_once '../../includes/footer.php'; ?> 