<?php
require_once '../../config/config.php';
require_once '../../includes/auth.php';
requireAdmin();
require_once '../../includes/header.php';

// Conexão com o banco
$database = new Database();
$db = $database->getConnection();

// Busca consultórios
$query = "SELECT * FROM consultorios ORDER BY numero";
$stmt = $db->prepare($query);
$stmt->execute();
$consultorios = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container mt-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="float-start">Consultórios</h5>
                    <button class="btn btn-primary float-end" data-bs-toggle="modal" data-bs-target="#addConsultorioModal">
                        Novo Consultório
                    </button>
                </div>
                <div class="card-body">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Número</th>
                                <th>Descrição</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($consultorios)): ?>
                                <tr>
                                    <td colspan="3" class="text-center">Nenhum consultório cadastrado</td>
                                </tr>
                            <?php else: ?>
                                <?php foreach ($consultorios as $cons): ?>
                                    <tr>
                                        <td><?php echo $cons['numero']; ?></td>
                                        <td><?php echo $cons['descricao']; ?></td>
                                        <td>
                                            <button class="btn btn-sm btn-info" onclick="editarConsultorio(<?php echo $cons['id']; ?>)">
                                                Editar
                                            </button>
                                            <button class="btn btn-sm btn-danger" onclick="excluirConsultorio(<?php echo $cons['id']; ?>)">
                                                Excluir
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal Adicionar Consultório -->
<div class="modal fade" id="addConsultorioModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Novo Consultório</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="formConsultorio">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Número *</label>
                        <input type="text" class="form-control" name="numero" required minlength="1">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Descrição</label>
                        <textarea class="form-control" name="descricao"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Salvar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Bootstrap JS e dependências -->
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script>

<script>
// Define a URL base para o JavaScript
const BASE_URL = '<?php echo BASE_URL; ?>';

// Funções para Consultórios
function editarConsultorio(id) {
    fetch(`${BASE_URL}/src/admin/consultorio.php?action=read&id=${id}`)
        .then(response => response.json())
        .then(data => {
            document.querySelector('#formConsultorio input[name="numero"]').value = data.numero;
            document.querySelector('#formConsultorio textarea[name="descricao"]').value = data.descricao;
            document.querySelector('#formConsultorio').dataset.id = id;
            
            const modal = new bootstrap.Modal(document.getElementById('addConsultorioModal'));
            modal.show();
        })
        .catch(error => {
            console.error('Erro:', error);
            alert('Erro ao carregar dados do consultório');
        });
}

function excluirConsultorio(id) {
    if (confirm('Deseja realmente excluir este consultório?')) {
        const formData = new FormData();
        formData.append('action', 'delete');
        formData.append('id', id);

        fetch(`${BASE_URL}/src/admin/consultorio.php`, {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message);
            }
        })
        .catch(error => {
            console.error('Erro:', error);
            alert('Erro ao excluir consultório');
        });
    }
}

// Tratamento do formulário
document.getElementById('formConsultorio').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const numero = this.querySelector('[name="numero"]').value.trim();
    if (!numero) {
        alert('O número do consultório é obrigatório');
        return;
    }
    
    const formData = new FormData(this);
    formData.append('action', this.dataset.id ? 'update' : 'create');
    if (this.dataset.id) {
        formData.append('id', this.dataset.id);
    }

    fetch(`${BASE_URL}/src/admin/consultorio.php`, {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        } else {
            alert(data.message);
        }
    })
    .catch(error => {
        console.error('Erro:', error);
        alert('Erro ao salvar consultório');
    });
});
</script>

<?php require_once '../../includes/footer.php'; ?> 