<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Debug
error_log("Carregando config.php");

// Inclui a classe Database
require_once __DIR__ . '/database.php';
error_log("Database.php incluído");

// Configurações de localização e timezone
setlocale(LC_ALL, 'pt_BR.UTF-8', 'portuguese');
date_default_timezone_set('America/Sao_Paulo');

// Configurações do sistema
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

define('BASE_URL', 'https://weblab.prodigitall.com.br');
define('SITE_NAME', 'Sistema de Fila - Clínica');

// Configurações do banco
define('DB_HOST', 'localhost');
define('DB_NAME', 'prodi970_chamada');
define('DB_USER', 'prodi970_chamada');
define('DB_PASS', 'chamada123');

// Funções de utilidade
function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

function isAdmin() {
    return isset($_SESSION['user_type']) && $_SESSION['user_type'] === 'admin';
}

function isMedico() {
    return isset($_SESSION['user_type']) && $_SESSION['user_type'] === 'medico';
}

function redirect($path) {
    $url = BASE_URL . $path;
    header("Location: " . $url);
    exit();
}

// Tratamento de erros
function handleError($error) {
    error_log($error);
    // Log de erros mais detalhado
    error_log(date('Y-m-d H:i:s') . " - " . $error . "\n", 3, __DIR__ . '/../logs/error.log');
}

// Proteção contra SQL Injection
function sanitize($input) {
    if (is_array($input)) {
        return array_map('sanitize', $input);
    }
    return htmlspecialchars(strip_tags($input));
}

// Função para verificar se a conexão está ativa
function checkConnection() {
    try {
        $database = new Database();
        $db = $database->getConnection();
        return $db !== null;
    } catch(Exception $e) {
        handleError($e->getMessage());
        return false;
    }
}

error_log("Config carregado com BASE_URL: " . BASE_URL);
?> 