<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';

// Verificar login
if (!isLoggedIn() || $_SESSION['user']['type'] !== 'admin') {
    header("Location: ../index.php");
    exit();
}

// Buscar pacientes
$search = $_GET['search'] ?? '';
$patients = getAllPatients($search);
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de Pacientes</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
</head>
<body class="bg-gray-100">
    <div class="container mx-auto px-4 py-8">
        <!-- Cabeçalho e botão voltar (esconder na impressão) -->
        <div class="flex justify-between items-center mb-6 print:hidden">
            <h1 class="text-3xl font-bold">Pacientes Cadastrados</h1>
            <a href="index.php" class="bg-gray-500 hover:bg-gray-600 text-white font-bold py-2 px-4 rounded">
                Voltar
            </a>
        </div>

        <!-- Título para impressão -->
        <div class="hidden print:block mb-6">
            <h1 class="text-3xl font-bold text-center">Lista de Pacientes Cadastrados</h1>
        </div>

        <!-- Formulário de busca (esconder na impressão) -->
        <div class="mb-6 print:hidden">
            <form method="get" class="flex gap-4">
                <input type="text" name="search" value="<?= htmlspecialchars($search) ?>" 
                       placeholder="Buscar por nome ou CPF..."
                       class="flex-1 shadow appearance-none border rounded py-2 px-3">
                <button type="submit" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                    Buscar
                </button>
            </form>
        </div>

        <!-- Botão de impressão (esconder na impressão) -->
        <div class="mb-4 print:hidden">
            <button onclick="window.print()" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                <i class="fas fa-print"></i> Imprimir
            </button>
        </div>

        <!-- Tabela de pacientes -->
        <div class="bg-white shadow-md rounded my-6 overflow-x-auto print:shadow-none print:rounded-none">
            <table class="min-w-full table-auto">
                <thead>
                    <tr class="bg-gray-200 text-gray-600 uppercase text-sm leading-normal">
                        <th class="py-3 px-6 text-left text-base">Nome</th>
                        <th class="py-3 px-6 text-left text-base">WhatsApp</th>
                        <th class="py-3 px-6 text-left text-base">Data Nasc.</th>
                        <th class="py-3 px-6 text-left text-base">Status</th>
                        <th class="py-3 px-6 text-center print:hidden text-base">Ações</th>
                    </tr>
                </thead>
                <tbody class="text-gray-600">
                    <?php foreach ($patients as $patient): ?>
                        <tr class="border-b border-gray-200 hover:bg-gray-100">
                            <td class="py-3 px-6 text-base"><?= htmlspecialchars($patient['name']) ?></td>
                            <td class="py-3 px-6 text-base">
                                <?= $patient['whatsapp'] ? formatPhone($patient['whatsapp']) : '-' ?>
                            </td>
                            <td class="py-3 px-6 text-base">
                                <?= $patient['birth_date'] ? date('d/m/Y', strtotime($patient['birth_date'])) : '-' ?>
                            </td>
                            <td class="py-3 px-6 text-base"><?= htmlspecialchars($patient['status']) ?></td>
                            <td class="py-3 px-6 text-center print:hidden">
                                <a href="editar_paciente.php?id=<?= $patient['id'] ?>" 
                                   class="bg-blue-500 hover:bg-blue-600 text-white border border-blue-500 rounded-full w-8 h-8 inline-flex items-center justify-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.232 5.232l3.536 3.536m-2.036-5.036a2.5 2.5 0 113.536 3.536L6.5 21.036H3v-3.572L16.732 3.732z" />
                                    </svg>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <style>
        @media print {
            .print\:hidden {
                display: none !important;
            }
            .print\:block {
                display: block !important;
            }
            .print\:shadow-none {
                box-shadow: none !important;
            }
            .print\:rounded-none {
                border-radius: 0 !important;
            }
            body {
                background-color: white;
                print-color-adjust: exact;
                -webkit-print-color-adjust: exact;
            }
            @page {
                margin: 2cm;
            }
        }
    </style>
</body>
</html> 