<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';

// Verificar login e permissões de admin
if (!isLoggedIn() || $_SESSION['user']['type'] !== 'admin') {
    header("Location: ../index.php");
    exit();
}

// Buscar estatísticas do banco
$db = Database::getInstance()->getConnection();

// Total de médicos
$stmt = $db->query("SELECT COUNT(*) as total FROM doctors");
$total_doctors = $stmt->fetch()['total'];

// Total de pacientes aguardando
$stmt = $db->query("SELECT COUNT(*) as total FROM patients WHERE called = 0");
$waiting_patients = $stmt->fetch()['total'];

// Total de pacientes chamados hoje
$stmt = $db->query("
    SELECT COUNT(*) as total 
    FROM patients 
    WHERE called = 1 
    AND DATE(created_at) = CURDATE()
");
$called_today = $stmt->fetch()['total'];

// Tempo médio de espera hoje
$stmt = $db->query("
    SELECT SEC_TO_TIME(AVG(TIME_TO_SEC(waiting_time))) as avg_time
    FROM patients 
    WHERE called = 1 
    AND DATE(created_at) = CURDATE()
");
$avg_waiting_time = $stmt->fetch()['avg_time'];
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Administração</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-100">
    <div class="container mx-auto px-4 py-8">
        <div class="flex justify-between items-center mb-8">
            <h1 class="text-3xl font-bold">Dashboard</h1>
            <div class="flex items-center space-x-4">
                <span class="text-gray-600">Bem-vindo, <?= htmlspecialchars($_SESSION['user']['name']) ?></span>
                <a href="../logout.php" class="bg-red-500 hover:bg-red-600 text-white font-bold py-2 px-4 rounded">
                    Sair
                </a>
            </div>
        </div>

        <!-- Cards de Estatísticas -->
        <div class="grid md:grid-cols-4 gap-6 mb-8">
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-600 mb-2">Médicos Cadastrados</h3>
                <p class="text-3xl font-bold"><?= $total_doctors ?></p>
            </div>
            
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-600 mb-2">Pacientes Aguardando</h3>
                <p class="text-3xl font-bold text-yellow-600"><?= $waiting_patients ?></p>
            </div>
            
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-600 mb-2">Atendimentos Hoje</h3>
                <p class="text-3xl font-bold text-green-600"><?= $called_today ?></p>
            </div>
            
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-600 mb-2">Tempo Médio de Espera</h3>
                <p class="text-3xl font-bold text-blue-600"><?= $avg_waiting_time ?: '00:00:00' ?></p>
            </div>
        </div>

        <!-- Links Rápidos -->
        <div class="grid md:grid-cols-3 gap-6">
            <a href="fila.php" class="bg-white rounded-lg shadow p-6 hover:shadow-lg transition-shadow">
                <h3 class="text-xl font-bold text-blue-600 mb-2">Fila de Pacientes</h3>
                <p class="text-gray-600">Gerenciar fila de atendimento</p>
            </a>
            
            <a href="cadastro_medico.php" class="bg-white rounded-lg shadow p-6 hover:shadow-lg transition-shadow">
                <h3 class="text-xl font-bold text-green-600 mb-2">Cadastro de Médicos</h3>
                <p class="text-gray-600">Gerenciar médicos e especialidades</p>
            </a>
            
            <a href="settings.php" class="bg-white rounded-lg shadow p-6 hover:shadow-lg transition-shadow">
                <h3 class="text-xl font-bold text-purple-600 mb-2">Configurações</h3>
                <p class="text-gray-600">Gerenciar configurações do sistema</p>
            </a>
        </div>
    </div>
</body>
</html> 