<?php
/**
 * CliniSys - Configurações do Sistema
 * Arquivo de configuração principal
 */

// Configurações do Banco de Dados
define('DB_HOST', 'localhost');
define('DB_NAME', 'clinisys');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_CHARSET', 'utf8mb4');

// Configurações do Sistema
define('SITE_URL', 'http://localhost');
define('SITE_NAME', 'CliniSys - Sistema de Gestão Clínica');
define('SITE_VERSION', '1.0.0');

// Configurações de Sessão
define('SESSION_TIMEOUT', 3600); // 1 hora em segundos

// Configurações de Segurança
define('HASH_ALGORITHM', 'sha256');
define('ENCRYPTION_KEY', 'clinisys_2024_secure_key');

// Configurações de Fila
define('POLLING_INTERVAL', 5000); // 5 segundos em milissegundos
define('MAX_CHAMADAS_EXIBICAO', 5);

// Configurações de Agendamento
define('TEMPO_CONSULTA_PADRAO', 30); // minutos
define('ANTECEDENCIA_MINIMA', 1); // horas
define('MAX_AGENDAMENTOS_DIA', 50);

// Configurações de Timezone
date_default_timezone_set('America/Sao_Paulo');

// Configurações de Erro
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Configurações de Upload
define('UPLOAD_MAX_SIZE', 5 * 1024 * 1024); // 5MB
define('UPLOAD_ALLOWED_TYPES', ['jpg', 'jpeg', 'png', 'pdf', 'doc', 'docx']);

// Configurações de Email (para futuras implementações)
define('SMTP_HOST', 'smtp.gmail.com');
define('SMTP_PORT', 587);
define('SMTP_USER', '');
define('SMTP_PASS', '');

// Headers de Segurança
header('X-Content-Type-Options: nosniff');
header('X-Frame-Options: DENY');
header('X-XSS-Protection: 1; mode=block');

// Configurações de CORS para API
if (isset($_SERVER['HTTP_ORIGIN'])) {
    header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
    header('Access-Control-Allow-Credentials: true');
    header('Access-Control-Max-Age: 86400');
}

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD'])) {
        header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
    }
    if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS'])) {
        header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
    }
    exit(0);
}
?>

