<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CliniSys - TV Sala de Espera</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #1a56db;
            --secondary-color: #7c3aed;
            --accent-color: #f59e0b;
            --text-light: #f3f4f6;
            --text-dark: #1f2937;
            --bg-dark: #111827;
            --bg-card: #1e293b;
        }

        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap');

        body {
            background-color: var(--bg-dark);
            color: var(--text-light);
            font-family: 'Inter', sans-serif;
            margin: 0;
            padding: 0;
            height: 100vh;
            width: 100vw;
            overflow: hidden;
            position: fixed;
        }

        .container-fluid {
            height: 100vh;
            width: 100vw;
            padding: 0;
            margin: 0;
            overflow: hidden;
            position: fixed;
        }

        .tv-header {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            padding: 1rem;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            height: 80px;
        }

        .clinic-name {
            font-size: 2rem;
            font-weight: 700;
            margin: 0;
            color: var(--text-light);
        }

        .clock {
            font-size: 2rem;
            font-weight: 700;
            color: var(--text-light);
            text-align: right;
            white-space: nowrap;
        }

        .tv-main {
            padding: 1rem;
            height: calc(100vh - 160px);
            display: flex;
            flex-direction: column;
            overflow: hidden;
        }

        .calls-container {
            background-color: var(--bg-card);
            border-radius: 1rem;
            padding: 1rem;
            flex-grow: 1;
            display: flex;
            flex-direction: column;
            box-shadow: 0 4px 6px -1px rgba(0,0,0,0.1);
            overflow: hidden;
        }

        .section-title {
            color: var(--accent-color);
            font-size: 1.5rem;
            font-weight: 700;
            margin-bottom: 1rem;
            text-transform: uppercase;
            letter-spacing: 0.05em;
        }

        .calls-list {
            display: flex;
            flex-direction: column;
            gap: 1rem;
            flex-grow: 1;
            overflow: hidden;
        }

        .call-item {
            background: rgba(255,255,255,0.05);
            border-radius: 1rem;
            padding: 1rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: all 0.3s ease;
            border: 1px solid rgba(255,255,255,0.1);
        }

        .call-item.current {
            background: linear-gradient(135deg, var(--accent-color), #fbbf24);
            transform: scale(1.05);
            box-shadow: 0 8px 24px rgba(245,158,11,0.3);
            padding: 3rem;
            margin: 1rem 0;
            display: flex;
            flex-direction: column;
            align-items: center;
            text-align: center;
            gap: 2rem;
            border-radius: 2rem;
        }

        .call-item.current .patient-name {
            font-size: 4rem;
            color: var(--text-dark);
            font-weight: 800;
            text-shadow: 0 2px 4px rgba(0,0,0,0.1);
            line-height: 1.2;
        }

        .call-item.current .consultorio {
            font-size: 3rem;
            color: var(--text-dark);
            font-weight: 700;
            background: rgba(0,0,0,0.1);
            padding: 1rem 3rem;
            border-radius: 9999px;
        }

        .call-item:hover {
            transform: translateX(-5px);
            background: rgba(255,255,255,0.1);
        }

        .call-item.current:hover {
            transform: scale(1.05);
        }

        .patient-name {
            font-size: 1.5rem;
            font-weight: 600;
            color: var(--text-light);
        }

        .consultorio {
            font-size: 1.5rem;
            font-weight: 600;
            color: var(--accent-color);
            background: rgba(245,158,11,0.1);
            padding: 0.5rem 1rem;
            border-radius: 9999px;
        }

        .legend {
            margin-top: 1rem;
            padding: 1rem;
            background: rgba(255,255,255,0.05);
            border-radius: 0.5rem;
            border: 1px solid rgba(255,255,255,0.1);
        }

        .legend-title {
            color: var(--accent-color);
            font-size: 1rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
        }

        .legend-text {
            color: var(--text-light);
            opacity: 0.8;
            font-size: 0.9rem;
            line-height: 1.4;
        }

        .info-container {
            height: 100%;
            display: flex;
            flex-direction: column;
            gap: 1.5rem;
        }

        .info-box {
            background-color: var(--bg-card);
            border-radius: 1rem;
            padding: 1.5rem;
            text-align: center;
            box-shadow: 0 4px 6px -1px rgba(0,0,0,0.1);
        }

        .info-box h4 {
            color: var(--text-light);
            font-size: 1.2rem;
            font-weight: 600;
            margin: 1rem 0;
        }

        .info-box p {
            color: var(--text-light);
            opacity: 0.8;
            margin: 0.5rem 0;
        }

        .video-placeholder {
            background: rgba(255,255,255,0.05);
            border-radius: 0.5rem;
            padding: 2rem;
            margin-top: 1rem;
        }

        .tv-footer {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            padding: 1rem;
            text-align: center;
            color: var(--text-light);
            font-weight: 500;
            font-size: 1rem;
            height: 60px;
        }

        .empty-state {
            text-align: center;
            padding: 3rem;
            color: var(--text-light);
            opacity: 0.7;
        }

        .empty-state i {
            font-size: 3rem;
            margin-bottom: 1rem;
            color: var(--accent-color);
        }

        @media (max-width: 768px) {
            .clinic-name {
                font-size: 2rem;
            }

            .clock {
                font-size: 2rem;
            }

            .call-item.current .patient-name {
                font-size: 3rem;
            }

            .call-item.current .consultorio {
                font-size: 2.5rem;
            }
        }

        @keyframes chamar-paciente {
            0% { transform: scale(1); }
            50% { transform: scale(1.2); }
            100% { transform: scale(1); }
        }

        .chamando {
            animation: chamar-paciente 1s ease-in-out;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <!-- Header -->
        <header class="tv-header">
            <div class="row align-items-center">
                <div class="col-md-8">
                    <h1 class="clinic-name">
                        <i class="fas fa-clinic-medical me-3"></i>
                        CliniSys - Clínica Multidisciplinar
                    </h1>
                </div>
                <div class="col-md-4">
                    <div id="clock" class="clock"></div>
                </div>
            </div>
        </header>

        <!-- Main Content -->
        <main class="tv-main">
            <div class="row h-100">
                <!-- Chamadas -->
                <div class="col-md-8">
                    <div class="calls-container">
                        <h2 class="section-title">Chamadas</h2>
                        <div id="calls-list" class="calls-list">
                            <!-- Chamadas carregadas via JavaScript -->
                        </div>
                    </div>
                </div>
                
                <!-- Informações Adicionais -->
                <div class="col-md-4">
                    <div class="info-container">
                        <div class="info-box">
                            <i class="fas fa-wifi fa-2x text-primary mb-2"></i>
                            <h4>Wi-Fi Gratuito</h4>
                            <p>Rede: <strong>CliniSys_WiFi</strong></p>
                            <p>Senha: <strong>clinisys123</strong></p>
                        </div>
                        <div class="info-box">
                            <i class="fas fa-info-circle fa-2x text-success mb-2"></i>
                            <h4>Avisos Importantes</h4>
                            <p id="avisos">Mantenha o silêncio na sala de espera. Em caso de dúvidas, procure a recepção.</p>
                        </div>
                        <div class="info-box">
                            <i class="fas fa-video fa-2x text-warning mb-2"></i>
                            <h4>Vídeo Institucional</h4>
                            <div id="video-placeholder" class="video-placeholder">
                                <p>Seu vídeo aqui</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>

        <!-- Footer -->
        <footer class="tv-footer">
            <p id="ticker">CliniSys - Cuidando da sua saúde com excelência. Agradecemos a sua preferência!</p>
        </footer>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const callsListEl = document.getElementById('calls-list');
            const clockEl = document.getElementById('clock');
            let ultimoIdAnunciado = null;
            let ultimaChamadaVoz = null;

            function falarTexto(texto) {
                if ('speechSynthesis' in window) {
                    window.speechSynthesis.cancel();
                    
                    const utterance = new SpeechSynthesisUtterance(texto);
                    utterance.lang = 'pt-BR';
                    utterance.rate = 0.9;
                    utterance.volume = 1;
                    
                    ultimaChamadaVoz = utterance;
                    window.speechSynthesis.speak(utterance);
                }
            }

            function atualizarChamadas() {
                fetch('api/get_chamadas_tv.php')
                .then(response => response.json())
                .then(data => {
                    if (data.length > 0) {
                        callsListEl.innerHTML = '';
                        
                        data.forEach((chamada, index) => {
                            const callItem = document.createElement('div');
                            callItem.className = 'call-item' + (index === 0 ? ' current' : '');
                            callItem.innerHTML = `
                                <span class="patient-name">${chamada.nome_paciente}</span>
                                <span class="consultorio">${chamada.numero_consultorio}</span>
                            `;
                            callsListEl.appendChild(callItem);

                            // Anuncia apenas a chamada mais recente
                            if (index === 0 && chamada.id !== ultimoIdAnunciado) {
                                ultimoIdAnunciado = chamada.id;
                                const textoParaFalar = `${chamada.nome_paciente}, por favor, dirija-se ao ${chamada.numero_consultorio}.`;
                                falarTexto(textoParaFalar);
                                
                                // Adiciona animação de chamada
                                callItem.classList.add('chamando');
                                setTimeout(() => {
                                    callItem.classList.remove('chamando');
                                }, 1000);
                            }
                        });
                    } else {
                        callsListEl.innerHTML = `
                            <div class="empty-state">
                                <i class="fas fa-emoji-smile"></i>
                                <p>Nenhuma chamada no momento</p>
                            </div>
                        `;
                        ultimoIdAnunciado = null;
                    }
                })
                .catch(error => {
                    console.error('Erro ao atualizar chamadas:', error);
                });
            }
            
            function atualizarRelogio() {
                const agora = new Date();
                const horas = String(agora.getHours()).padStart(2, '0');
                const minutos = String(agora.getMinutes()).padStart(2, '0');
                const segundos = String(agora.getSeconds()).padStart(2, '0');
                
                // Atualiza a data e hora
                const opcoesData = { 
                    weekday: 'long', 
                    year: 'numeric', 
                    month: 'long', 
                    day: 'numeric' 
                };
                const dataFormatada = agora.toLocaleDateString('pt-BR', opcoesData);
                
                document.getElementById('clock').textContent = `${dataFormatada} - ${horas}:${minutos}:${segundos}`;
            }

            // Inicialização
            atualizarChamadas();
            atualizarRelogio();
            
            // Atualizações periódicas
            setInterval(atualizarChamadas, 5000);
            setInterval(atualizarRelogio, 1000);
        });
    </script>
</body>
</html> 