<?php
session_start();
header('Content-Type: application/json; charset=utf-8');
require_once '../conexao.php';

// Proteção
if (!isset($_SESSION['admin_id'])) {
    echo json_encode(['success' => false, 'message' => 'Acesso negado.']);
    exit;
}

$dados = json_decode(file_get_contents('php://input'), true);
$id_agendamento = $dados['id'] ?? 0;

if ($id_agendamento > 0) {
    // Também removemos da fila de espera, caso o paciente já tenha feito check-in
    $conexao->query("DELETE FROM fila_espera WHERE id_agendamento = " . intval($id_agendamento));

    $stmt = $conexao->prepare("DELETE FROM agendamentos WHERE id = ?");
    $stmt->bind_param("i", $id_agendamento);
    if ($stmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Agendamento cancelado com sucesso.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Erro ao cancelar o agendamento.']);
    }
    $stmt->close();
} else {
    echo json_encode(['success' => false, 'message' => 'ID de agendamento inválido.']);
}
$conexao->close();
?>