<?php
// Remover verificação de sessão para testes
// session_start();
header('Content-Type: application/json; charset=utf-8');
require_once '../conexao.php';

$dados = json_decode(file_get_contents('php://input'), true);
$id_agendamento = $dados['id'] ?? 0;
$nova_data_hora = $dados['start'] ?? '';
$novo_status = isset($dados['status']) ? strtolower($dados['status']) : null;
$novo_paciente_id = $dados['pacienteId'] ?? null;
$novo_medico_id = $dados['medicoId'] ?? null;
$nova_especialidade_id = $dados['especialidadeId'] ?? null;

// Mapeamento dos status do sistema para os valores do ENUM do banco
$status_map = [
    'agendado' => 'Agendado',
    'confirmado' => 'Confirmado',
    'cancelado' => 'Cancelado',
    'atendimento' => 'Realizado',
    'realizado' => 'Realizado',
    'naocompareceu' => 'NaoCompareceu',
    'nao_compareceu' => 'NaoCompareceu',
    'fila' => 'Aguardando',
];
$novo_status_salvar = $novo_status && isset($status_map[$novo_status]) ? $status_map[$novo_status] : null;
error_log('Status recebido: ' . $novo_status . ' | Status salvo: ' . $novo_status_salvar);

// Log para depuração
error_log("Dados recebidos: " . print_r($dados, true));
error_log("ID: $id_agendamento, Status: $novo_status_salvar");

if ($id_agendamento > 0) {
    $atualizou = false;
    
    // Se temos dados completos do agendamento (edição completa)
    if (!empty($nova_data_hora) && !empty($novo_paciente_id) && !empty($novo_medico_id) && !empty($nova_especialidade_id)) {
        $sql = "UPDATE agendamentos SET 
                    data_hora_agendamento = '$nova_data_hora',
                    id_paciente = $novo_paciente_id,
                    id_medico = $novo_medico_id,
                    id_especialidade_agendada = $nova_especialidade_id
                WHERE id = $id_agendamento";
        if ($conexao->query($sql)) {
            $atualizou = true;
        } else {
            echo json_encode(['success' => false, 'message' => 'Erro ao atualizar agendamento: ' . $conexao->error]);
            $conexao->close();
            exit;
        }
    } else {
        // Atualizações individuais (como antes)
        if (!empty($nova_data_hora)) {
            // Atualiza data/hora
            $sql = "UPDATE agendamentos SET data_hora_agendamento = '$nova_data_hora' WHERE id = $id_agendamento";
            if ($conexao->query($sql)) {
                $atualizou = true;
            } else {
                echo json_encode(['success' => false, 'message' => 'Erro ao atualizar agendamento: ' . $conexao->error]);
                $conexao->close();
                exit;
            }
        }
        if (!empty($novo_status_salvar)) {
            // Atualiza status
            $sql = "UPDATE agendamentos SET status_agendamento = '$novo_status_salvar' WHERE id = $id_agendamento";
            error_log("SQL: $sql");
            if ($conexao->query($sql)) {
                $atualizou = true;
            } else {
                echo json_encode(['success' => false, 'message' => 'Erro ao atualizar status: ' . $conexao->error]);
                $conexao->close();
                exit;
            }
        }
    }
    if ($atualizou) {
        echo json_encode(['success' => true, 'message' => 'Agendamento atualizado com sucesso.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Nenhum dado para atualizar.']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Dados inválidos para atualização.']);
}
$conexao->close();
?>