<?php
$titulo_pagina = "Gerenciar Médicos";
include_once './_template/header.php';
require_once '../conexao.php';

// SQL CORRIGIDO: Usamos LEFT JOIN para garantir que todos os médicos apareçam,
// mesmo que ainda não tenham especialidades vinculadas.
$sql = "SELECT 
            m.id, 
            m.nome_completo, 
            m.whatsapp, 
            m.email, 
            m.foto,
            m.ativo, 
            GROUP_CONCAT(e.nome ORDER BY e.nome SEPARATOR ', ') as especialidades
        FROM 
            medicos m
        LEFT JOIN 
            medico_especialidades me ON m.id = me.id_medico
        LEFT JOIN 
            especialidades e ON me.id_especialidade = e.id
        GROUP BY 
            m.id
        ORDER BY 
            m.nome_completo";
            
$resultado = $conexao->query($sql);

// Função para obter iniciais do nome
function obterIniciais($nome) {
    $palavras = explode(' ', trim($nome));
    $iniciais = '';
    foreach ($palavras as $palavra) {
        if (!empty($palavra)) {
            $iniciais .= strtoupper(substr($palavra, 0, 1));
            if (strlen($iniciais) >= 2) break; // Máximo 2 iniciais
        }
    }
    return $iniciais;
}
?>

<?php if (isset($_SESSION['success_message'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo $_SESSION['success_message']; unset($_SESSION['success_message']); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<?php if (isset($_SESSION['error_message'])): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?php echo $_SESSION['error_message']; unset($_SESSION['error_message']); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<style>
body {
    background-color: #ebebeb !important;
}

.main-content {
    padding: 1.5rem !important;
    background-color: #ebebeb !important;
}

.card.shadow {
    background: white;
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
}

.medico-card {
    transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
    border: none;
    border-radius: 6px;
    background: white;
    box-shadow: 0 4px 12px rgba(0,0,0,0.25);
    overflow: hidden;
    position: relative;
}

.medico-card-header {
    background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
    color: white;
    padding: 16px 20px;
    display: flex;
    align-items: center;
    border-top-left-radius: 6px;
    border-top-right-radius: 6px;
}

.medico-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.35);
}

.medico-card .card-body {
    padding: 16px 20px 20px 20px;
}

.medico-avatar {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.2rem;
    font-weight: bold;
    color: white;
    background: rgba(255, 255, 255, 0.2);
    margin-right: 12px;
    flex-shrink: 0;
    border: 2px solid rgba(255, 255, 255, 0.3);
}

.medico-header-info {
    flex: 1;
    min-width: 0;
}

.medico-header-nome {
    font-size: 1.1rem;
    font-weight: 600;
    color: white;
    margin-bottom: 2px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.medico-header-whatsapp {
    color: rgba(255, 255, 255, 0.9);
    font-size: 0.85rem;
    font-weight: 400;
}

.medico-avatar img {
    width: 100%;
    height: 100%;
    border-radius: 50%;
    object-fit: cover;
}

.medico-info {
    flex: 1;
    min-width: 0;
}

.medico-body-info {
    flex: 1;
}

.medico-especialidade {
    color: #6c757d;
    font-size: 0.85rem;
    margin-bottom: 12px;
    display: flex;
    align-items: center;
    gap: 6px;
}

.medico-especialidade i {
    color: #4a90e2;
    font-size: 0.9rem;
}

.medico-status {
    display: inline-flex;
    align-items: center;
    gap: 4px;
    padding: 6px 10px;
    border-radius: 16px;
    font-size: 0.75rem;
    font-weight: 500;
}

.medico-status i {
    font-size: 0.8rem;
}

.status-ativo {
    background-color: #d4edda;
    color: #155724;
}

.status-inativo {
    background-color: #f8d7da;
    color: #721c24;
}

.medico-acoes {
    display: flex;
    gap: 8px;
    align-items: center;
}

.btn-acao {
    width: 32px;
    height: 32px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.75rem;
    border: none;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.btn-acao:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
}

.btn-acao:active {
    transform: translateY(0);
}

.btn-toggle {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.btn-toggle:hover {
    background: linear-gradient(135deg, #5a6fd8 0%, #6a4190 100%);
    color: white;
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
}

.btn-editar {
    background: linear-gradient(135deg, #ffecd2 0%, #fcb69f 100%);
    color: #8b4513;
}

.btn-editar:hover {
    background: linear-gradient(135deg, #ffd89b 0%, #fa9e8c 100%);
    color: #8b4513;
    box-shadow: 0 4px 12px rgba(252, 182, 159, 0.4);
}

.btn-excluir {
    background: linear-gradient(135deg, #ff9a9e 0%, #fecfef 100%);
    color: #dc3545;
}

.btn-excluir:hover {
    background: linear-gradient(135deg, #ff8a8e 0%, #fdbfdf 100%);
    color: #dc3545;
    box-shadow: 0 4px 12px rgba(255, 154, 158, 0.4);
}
</style>

<div class="row">
    <?php if ($resultado && $resultado->num_rows > 0): ?>
        <?php while($medico = $resultado->fetch_assoc()): ?>
            <div class="col-md-6 col-lg-4 mb-4">
                <div class="card medico-card shadow-sm h-100">
                    <!-- Header colorido com nome e WhatsApp -->
                    <div class="medico-card-header">
                        <div class="medico-avatar">
                            <?php if (!empty($medico['foto']) && file_exists('../' . $medico['foto'])): ?>
                                <img src="../<?php echo htmlspecialchars($medico['foto']); ?>" alt="Foto do médico" style="width: 100%; height: 100%; border-radius: 50%; object-fit: cover;">
                            <?php else: ?>
                                <?php echo obterIniciais($medico['nome_completo']); ?>
                            <?php endif; ?>
                        </div>
                        
                        <div class="medico-header-info">
                            <div class="medico-header-nome" title="<?php echo htmlspecialchars($medico['nome_completo']); ?>">
                                <?php echo htmlspecialchars($medico['nome_completo']); ?>
                            </div>
                            <div class="medico-header-whatsapp">
                                <?php echo htmlspecialchars($medico['whatsapp']); ?>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Body com especialidade, status e ações -->
                    <div class="card-body">
                        <div class="medico-especialidade">
                            <i class="bi bi-mortarboard-fill"></i>
                            <span><?php echo htmlspecialchars($medico['especialidades'] ?? 'Nenhuma especialidade'); ?></span>
                        </div>
                        
                        <div class="d-flex justify-content-between align-items-center">
                            <span class="medico-status <?php echo $medico['ativo'] ? 'status-ativo' : 'status-inativo'; ?>">
                                <i class="bi <?php echo $medico['ativo'] ? 'bi-check-circle-fill' : 'bi-x-circle-fill'; ?>"></i>
                                <span><?php echo $medico['ativo'] ? 'Ativo' : 'Inativo'; ?></span>
                            </span>
                            
                            <div class="medico-acoes">
                                <a href="medicos_acao.php?acao=toggle_status&id=<?php echo $medico['id']; ?>" 
                                   class="btn btn-acao btn-toggle" 
                                   title="<?php echo $medico['ativo'] ? 'Desativar' : 'Ativar'; ?>">
                                    <i class="bi <?php echo $medico['ativo'] ? 'bi-toggle-on' : 'bi-toggle-off'; ?>"></i>
                                </a>
                                
                                <a href="medicos_editar.php?id=<?php echo $medico['id']; ?>" 
                                   class="btn btn-acao btn-editar" 
                                   title="Editar">
                                    <i class="bi bi-gear-fill"></i>
                                </a>
                                
                                <button type="button" 
                                        class="btn btn-acao btn-excluir" 
                                        title="Excluir"
                                        onclick="confirmarExclusao(<?php echo $medico['id']; ?>, '<?php echo htmlspecialchars($medico['nome_completo']); ?>')">
                                    <i class="bi bi-x-lg"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endwhile; ?>
    <?php else: ?>
        <div class="col-12">
            <div class="alert alert-info text-center">
                <i class="bi bi-info-circle"></i> Nenhum médico cadastrado.
            </div>
        </div>
    <?php endif; ?>
</div>

<script>
function confirmarExclusao(id, nome) {
    if (confirm(`Tem certeza que deseja excluir o médico "${nome}"?\n\nEsta ação não pode ser desfeita.`)) {
        window.location.href = `medicos_acao.php?acao=excluir&id=${id}`;
    }
}
</script>

<?php 
if ($resultado) $resultado->close();
$conexao->close();
include_once './_template/footer.php'; 
?>