<?php 
include_once './_template/header.php'; 
// Buscar todas as especialidades para o seletor
$especialidades_query = $conexao->query("SELECT id, nome FROM especialidades ORDER BY nome");
?>
<h1 class="h3 mb-4 text-gray-800"><?php echo $titulo_pagina; ?></h1>
<div class="card shadow mb-4">
    <div class="card-body">
        <form action="medicos_acao.php" method="POST" enctype="multipart/form-data">
            <input type="hidden" name="acao" value="<?php echo $acao; ?>">
            <?php if (isset($id)): ?><input type="hidden" name="id" value="<?php echo $id; ?>"><?php endif; ?>

            <div class="row">
                <div class="col-md-8 mb-3">
                    <label for="nome_completo" class="form-label">Nome Completo</label>
                    <input type="text" class="form-control" id="nome_completo" name="nome_completo" value="<?php echo $medico['nome_completo'] ?? ''; ?>" required>
                </div>
                <div class="col-md-4 mb-3">
                    <label for="whatsapp" class="form-label">WhatsApp (para login)</label>
                    <input type="text" class="form-control" id="whatsapp" name="whatsapp" value="<?php echo $medico['whatsapp'] ?? ''; ?>" required>
                </div>
            </div>

            <div class="mb-3">
                <label for="email" class="form-label">E-mail (opcional)</label>
                <input type="email" class="form-control" id="email" name="email" value="<?php echo $medico['email'] ?? ''; ?>">
            </div>

            <div class="mb-3">
                <label for="foto" class="form-label">Foto do Médico</label>
                <input type="file" class="form-control" id="foto" name="foto" accept="image/*">
                <small class="form-text text-muted">Formatos aceitos: JPG, PNG, GIF. Tamanho máximo: 500x500px. A imagem será redimensionada automaticamente.</small>
                <?php if (isset($medico['foto']) && !empty($medico['foto'])): ?>
                    <div class="mt-2">
                        <img src="../<?php echo $medico['foto']; ?>" alt="Foto atual" class="img-thumbnail" style="max-width: 100px; max-height: 100px;">
                        <small class="d-block text-muted">Foto atual</small>
                    </div>
                <?php endif; ?>
            </div>
            
            <div class="mb-3">
                <label for="endereco" class="form-label">Endereço (opcional)</label>
                <input type="text" class="form-control" id="endereco" name="endereco" value="<?php echo $medico['endereco'] ?? ''; ?>">
            </div>
            
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="duracao_consulta_min" class="form-label">Duração Padrão da Consulta (minutos)</label>
                    <input type="number" class="form-control" id="duracao_consulta_min" name="duracao_consulta_min" value="<?php echo $medico['duracao_consulta_min'] ?? '30'; ?>" required>
                </div>
            </div>
            <div class="mb-3">
                <label for="especialidades" class="form-label">Especialidades (segure Ctrl ou Cmd para selecionar várias)</label>
                <select multiple class="form-control" id="especialidades" name="especialidades[]" size="5" required>
                    <?php while ($especialidade = $especialidades_query->fetch_assoc()): ?>
                        <option value="<?php echo $especialidade['id']; ?>" <?php echo (isset($medico_especialidades) && in_array($especialidade['id'], $medico_especialidades)) ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($especialidade['nome']); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
            
            <div class="mb-3">
                <label for="senha" class="form-label">Senha</label>
                <input type="password" class="form-control" id="senha" name="senha" <?php echo ($acao == 'adicionar') ? 'required' : ''; ?>>
                <?php if ($acao == 'editar'): ?>
                    <small class="form-text text-muted">Deixe em branco para não alterar a senha atual.</small>
                <?php endif; ?>
            </div>

            <div class="d-flex justify-content-end">
                <a href="medicos_listar.php" class="btn btn-secondary me-2">Cancelar</a>
                <button type="submit" class="btn btn-primary">Salvar</button>
            </div>
        </form>
    </div>
</div>
<?php include_once './_template/footer.php'; ?>