<?php
// Valida se o ID do paciente foi passado pela URL
$idPaciente = $_GET['paciente_id'] ?? 0;
if ($idPaciente == 0) {
    header("Location: pacientes_listar.php");
    exit();
}

// Inclui a conexão ANTES de qualquer coisa para buscar os dados
require_once '../conexao.php';

// Busca os dados do paciente para exibir o nome
$stmt = $conexao->prepare("SELECT nome_completo FROM pacientes WHERE id = ?");
$stmt->bind_param("i", $idPaciente);
$stmt->execute();
$paciente = $stmt->get_result()->fetch_assoc();
$stmt->close();

// Se o paciente com aquele ID não existir, volta para a lista
if (!$paciente) {
     header("Location: pacientes_listar.php");
    exit();
}
$nomePaciente = $paciente['nome_completo'];

// Define o título da página e inclui o header
$titulo_pagina = "Agendar para: " . $nomePaciente;
include_once './_template/header.php';
?>

<div class="card shadow">
    <div class="card-header bg-primary text-white">
        <h1 class="h4 mb-0">Novo Agendamento para: <span class="fw-bold"><?php echo htmlspecialchars($nomePaciente); ?></span></h1>
    </div>
    <div class="card-body">
        <div class="row g-3">
            <div class="col-md-6"><label for="especialidade" class="form-label">1. Escolha a Especialidade:</label><select id="especialidade" class="form-select"></select></div>
            <div class="col-md-6"><label for="medico" class="form-label">2. Escolha o Médico:</label><select id="medico" class="form-select" disabled></select></div>
        </div>
        <hr class="my-4">
        <p class="text-center text-muted">3. Selecione um horário disponível no calendário abaixo.</p>
        <div id="calendario" class="mt-4"></div>
    </div>
</div>

<div class="modal fade" id="modalConfirmacao" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header"><h5 class="modal-title">Confirmar Agendamento</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
            <div class="modal-body">
                <p>Deseja confirmar o agendamento para:</p>
                <p><strong>Paciente:</strong> <?php echo htmlspecialchars($nomePaciente); ?></p>
                <p><strong>Médico:</strong> <span id="modalMedico"></span></p>
                <p><strong>Data e Hora:</strong> <span id="modalDataHora"></span></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" id="btnConfirmar" class="btn btn-primary">Sim, Confirmar</button>
            </div>
        </div>
    </div>
</div>

<script src='https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.js'></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const pacienteId = <?php echo $idPaciente; ?>;
    const especialidadeSelect = document.getElementById('especialidade');
    const medicoSelect = document.getElementById('medico');
    const calendarioEl = document.getElementById('calendario');
    const modalConfirmacao = new bootstrap.Modal(document.getElementById('modalConfirmacao'));
    const modalMedicoEl = document.getElementById('modalMedico');
    const modalDataHoraEl = document.getElementById('modalDataHora');
    const btnConfirmar = document.getElementById('btnConfirmar');
    let eventoClicadoInfo = null;

    let calendar = new FullCalendar.Calendar(calendarioEl, {
        locale: 'pt-br', initialView: 'timeGridWeek', allDaySlot: false,
        headerToolbar: { left: 'prev,next today', center: 'title', right: 'dayGridMonth,timeGridWeek,timeGridDay' },
        buttonText: { today: 'Hoje', month: 'Mês', week: 'Semana', day: 'Dia' },
        events: [],
        eventClick: function(info) {
            eventoClicadoInfo = info;
            const medicoNome = medicoSelect.options[medicoSelect.selectedIndex].text;
            const dataHora = new Date(info.event.start);
            const dataFormatada = dataHora.toLocaleDateString('pt-BR') + ' às ' + dataHora.toLocaleTimeString('pt-BR', { hour: '2-digit', minute: '2-digit' });
            
            modalMedicoEl.textContent = medicoNome;
            modalDataHoraEl.textContent = dataFormatada;
            modalConfirmacao.show();
        }
    });
    calendar.render();

    // O caminho para a API precisa ser relativo à localização deste arquivo
    // Como estamos em /admin/, usamos '../api/' para voltar um nível e entrar na pasta api
    const basePath = '../api/';

    fetch(`${basePath}get_especialidades.php`).then(r => r.json()).then(data => {
        especialidadeSelect.innerHTML = '<option selected disabled>-- Selecione --</option>';
        data.forEach(e => especialidadeSelect.add(new Option(e.nome, e.id)));
    });

    especialidadeSelect.addEventListener('change', function() {
        medicoSelect.disabled = true;
        medicoSelect.innerHTML = '<option>-- Carregando... --</option>';
        calendar.removeAllEvents();
        fetch(`${basePath}get_medicos.php?especialidade_id=${this.value}`).then(r => r.json()).then(data => {
            medicoSelect.innerHTML = '<option selected disabled>-- Selecione --</option>';
            if (data.length > 0) {
                data.forEach(m => medicoSelect.add(new Option(m.nome_completo, m.id)));
                medicoSelect.disabled = false;
            } else {
                medicoSelect.innerHTML = '<option>-- Nenhum médico --</option>';
            }
        });
    });

    medicoSelect.addEventListener('change', function() {
        if (this.value) {
            calendar.removeAllEvents();
            calendar.addEventSource(`${basePath}get_horarios.php?medico_id=${this.value}`);
        }
    });

    btnConfirmar.addEventListener('click', function() {
        const agendamento = {
            pacienteId: pacienteId,
            medicoId: medicoSelect.value,
            especialidadeId: especialidadeSelect.value,
            start: eventoClicadoInfo.event.startStr
        };

        fetch(`${basePath}salvar_agendamento.php`, {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(agendamento)
        })
        .then(response => response.json())
        .then(data => {
            alert(data.message);
            if (data.success) {
                modalConfirmacao.hide();
                eventoClicadoInfo.event.remove();
            }
        });
    });
});
</script>

<?php 
// A conexão já foi aberta no topo para buscar o nome do paciente
$conexao->close();
include_once './_template/footer.php'; 
?>