<?php
// Garante que a sessão seja iniciada apenas uma vez, da forma mais segura.
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Proteção definitiva da página: se não houver 'admin_id' na sessão, redireciona para o login.
if (!isset($_SESSION['admin_id'])) {
    header("Location: index.php");
    exit(); 
}

// Se chegou aqui, o usuário está logado.
$nome_admin = $_SESSION['admin_nome'];
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $titulo_pagina ?? 'Painel Administrativo'; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <style>
        * {
            font-family: 'Roboto', sans-serif !important;
        }
        
        body { 
            display: flex; 
            min-height: 100vh; 
            background-color: #f8f9fa; 
        }
        
        .sidebar { 
            min-width: 230px; 
            max-width: 230px; 
            background: linear-gradient(180deg, #2c3e50 0%, #34495e 100%);
            color: white; 
            box-shadow: 2px 0 10px rgba(0,0,0,0.1);
        }
        
        .sidebar .nav-link { 
            color: rgba(255, 255, 255, 0.8); 
            padding: 12px 20px; 
            border-radius: 8px; 
            margin-bottom: 4px; 
            transition: all 0.3s ease;
            font-weight: 400;
            border-left: 3px solid transparent;
        }
        
        .sidebar .nav-link:hover { 
            color: white; 
            background: rgba(255, 255, 255, 0.1);
            border-left-color: #4a90e2;
            transform: translateX(2px);
        }
        
        .sidebar .nav-link.active { 
            color: white; 
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            border-left-color: #ffffff;
            box-shadow: 0 2px 8px rgba(74, 144, 226, 0.3);
        }
        
        .sidebar .nav-link .bi { 
            margin-right: 12px; 
            font-size: 1.1rem;
        }
        
        .content { 
            flex-grow: 1; 
            padding: 0; 
            display: flex; 
            flex-direction: column; 
        }
        
        .top-bar { 
            background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
            padding: 1.2rem 1.5rem; 
            box-shadow: 0 2px 20px rgba(0,0,0,0.08);
            display: flex; 
            justify-content: space-between; 
            align-items: center;
            border-bottom: 1px solid rgba(0,0,0,0.05);
        }
        
        .top-bar h1 {
            color: #2c3e50;
            font-weight: 600;
            margin: 0;
            font-size: 1.5rem;
            letter-spacing: 0.5px;
        }
        
        .main-content { 
            padding: 1.5rem 0rem 1.5rem 1.5rem; 
            flex-grow: 1; 
        }
        
        .sidebar-brand-text { 
            font-size: 1.4rem; 
            font-weight: 700;
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            text-shadow: none;
        }
        
        .user-dropdown {
            background: rgba(255, 255, 255, 0.9);
            border-radius: 25px;
            padding: 8px 16px;
            transition: all 0.3s ease;
            border: 1px solid rgba(0,0,0,0.05);
        }
        
        .user-dropdown:hover {
            background: white;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            transform: translateY(-1px);
        }
        
        .user-dropdown .bi-person-circle {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .user-dropdown strong {
            color: #2c3e50;
            font-weight: 500;
        }
        
        .dropdown-menu {
            border: none;
            box-shadow: 0 8px 25px rgba(0,0,0,0.15);
            border-radius: 12px;
            padding: 8px;
        }
        
        .dropdown-item {
            border-radius: 8px;
            padding: 10px 16px;
            transition: all 0.2s ease;
            font-weight: 400;
        }
        
        .dropdown-item:hover {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            color: white;
        }
        
        hr.bg-secondary {
            border-color: rgba(255, 255, 255, 0.2);
            margin: 16px 0;
        }
    </style>
</head>
<body>
    <div class="sidebar p-3 d-flex flex-column">
        <div class="text-center mb-4">
            <a href="dashboard.php" class="text-white text-decoration-none sidebar-brand-text">CliniSys</a>
        </div>
    <ul class="nav flex-column flex-grow-1">
        <li class="nav-item">
            <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : ''; ?>" href="dashboard.php"><i class="bi bi-grid-1x2-fill"></i> Dashboard</a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'agenda_geral.php' ? 'active' : ''; ?>" href="agenda_geral.php"><i class="bi bi-calendar3"></i> Agenda</a>
        </li>
        <hr class="bg-secondary">
        <li class="nav-item">
            <a class="nav-link <?php echo strpos(basename($_SERVER['PHP_SELF']), 'pacientes') !== false ? 'active' : ''; ?>" href="pacientes_listar.php">
                <i class="bi bi-people-fill"></i> Pacientes
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo strpos(basename($_SERVER['PHP_SELF']), 'checkin') !== false ? 'active' : ''; ?>" href="checkin.php">
                <i class="bi bi-person-check-fill"></i> Check-in
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo strpos(basename($_SERVER['PHP_SELF']), 'fila_gerenciar') !== false ? 'active' : ''; ?>" href="fila_gerenciar.php">
                <i class="bi bi-list-ol"></i> Gerenciar Fila
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo strpos(basename($_SERVER['PHP_SELF']), 'alocacao') !== false ? 'active' : ''; ?>" href="alocacao_consultorios.php">
                <i class="bi bi-calendar-week-fill"></i> Alocação Diária
            </a>
        </li>
        <hr class="bg-secondary">
        <li class="nav-item">
            <a class="nav-link <?php echo strpos(basename($_SERVER['PHP_SELF']), 'medicos') !== false ? 'active' : ''; ?>" href="medicos_listar.php"><i class="bi bi-heart-pulse-fill"></i> Médicos</a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo strpos(basename($_SERVER['PHP_SELF']), 'especialidades') !== false ? 'active' : ''; ?>" href="especialidades_listar.php"><i class="bi bi-bookmark-star-fill"></i> Especialidades</a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo strpos(basename($_SERVER['PHP_SELF']), 'consultorios') !== false ? 'active' : ''; ?>" href="consultorios_listar.php"><i class="bi bi-door-open-fill"></i> Consultórios</a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo strpos(basename($_SERVER['PHP_SELF']), 'horarios') !== false ? 'active' : ''; ?>" href="medicos_horarios.php"><i class="bi bi-clock-history"></i> Horários</a>
        </li>
    </ul>
    <div class="mt-auto">
        <a class="nav-link" href="logout.php"><i class="bi bi-box-arrow-right"></i> Sair</a>
    </div>
    </div>
    <div class="content">
        <div class="top-bar">
             <h1><?php echo $titulo_pagina ?? 'Painel'; ?></h1>
             <div class="dropdown">
                <a href="#" class="d-flex align-items-center text-decoration-none dropdown-toggle user-dropdown" data-bs-toggle="dropdown" aria-expanded="false">
                    <i class="bi bi-person-circle fs-4 me-2"></i>
                    <strong><?php echo htmlspecialchars($nome_admin); ?></strong>
                </a>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item" href="logout.php"><i class="bi bi-box-arrow-right me-2"></i>Sair</a></li>
                </ul>
            </div>
        </div>
        <div class="main-content">