<?php
session_start();
require_once '../conexao.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $whatsapp = $_POST['whatsapp'];
    $senha = $_POST['senha'];

    $sql = "SELECT id, nome_completo, senha FROM medicos WHERE whatsapp = ? AND ativo = 1";
    $stmt = $conexao->prepare($sql);
    $stmt->bind_param("s", $whatsapp);
    $stmt->execute();
    $resultado = $stmt->get_result();

    if ($resultado->num_rows === 1) {
        $medico = $resultado->fetch_assoc();
        if (password_verify($senha, $medico['senha'])) {
            $_SESSION['medico_id'] = $medico['id'];
            $_SESSION['medico_nome'] = $medico['nome_completo'];
            header("Location: fila.php");
            exit();
        }
    }
    
    $_SESSION['login_error'] = "Celular ou senha inválidos, ou médico inativo.";
    header("Location: index.php");
    exit();
}
?>