<?php
header('Content-Type: application/json; charset=utf-8');
require_once '../conexao.php';

try {
    $termo = $_GET['term'] ?? '';
    $termo_like = "%" . $termo . "%";

    $sql = "SELECT id, nome_completo, cpf, telefone_contato, data_nascimento 
            FROM pacientes 
            WHERE nome_completo LIKE ? OR cpf LIKE ? OR telefone_contato LIKE ? 
            ORDER BY nome_completo 
            LIMIT 20";

    $stmt = $conexao->prepare($sql);
    if (!$stmt) {
        throw new Exception("Erro ao preparar a query: " . $conexao->error);
    }

    $stmt->bind_param("sss", $termo_like, $termo_like, $termo_like);
    if (!$stmt->execute()) {
        throw new Exception("Erro ao executar a query: " . $stmt->error);
    }

    $resultado = $stmt->get_result();
    $pacientes = [];

    while($row = $resultado->fetch_assoc()) {
        $pacientes[] = [
            'id' => $row['id'],
            'text' => $row['nome_completo'] . ' (' . $row['cpf'] . ')',
            'telefone' => $row['telefone_contato'],
            'data_nascimento' => $row['data_nascimento']
        ];
    }

    echo json_encode(['results' => $pacientes]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}

$conexao->close();
?>