<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['medico_id'])) {
    echo json_encode(['success' => false, 'message' => 'Acesso não autorizado.']);
    exit;
}

require_once '../conexao.php';

$dados = json_decode(file_get_contents('php://input'), true);
$idFila = $dados['id_fila'] ?? 0;

if ($idFila === 0) {
    echo json_encode(['success' => false, 'message' => 'ID da fila não fornecido.']);
    exit;
}

$idMedicoLogado = $_SESSION['medico_id'];

$conexao->begin_transaction();
try {
    // 1. Pega os dados do paciente e consultório da fila
    $sql_info = "SELECT p.nome_completo, c.numero_sala FROM fila_espera f 
                 JOIN agendamentos a ON f.id_agendamento = a.id
                 JOIN pacientes p ON a.id_paciente = p.id
                 JOIN consultorios c ON f.id_consultorio = c.id
                 WHERE f.id = ? AND f.id_medico = ?";
    $stmt_info = $conexao->prepare($sql_info);
    $stmt_info->bind_param("ii", $idFila, $idMedicoLogado);
    $stmt_info->execute();
    $info = $stmt_info->get_result()->fetch_assoc();

    if (!$info) {
        throw new Exception('Paciente não encontrado na sua fila.');
    }
    $nomePaciente = $info['nome_completo'];
    $numConsultorio = $info['numero_sala'];

    // 2. Atualiza o status do paciente na fila para 'Em Atendimento'
    $sql_update = "UPDATE fila_espera SET status_fila = 'Em Atendimento', hora_chamada = NOW() WHERE id = ?";
    $stmt_update = $conexao->prepare($sql_update);
    $stmt_update->bind_param("i", $idFila);
    $stmt_update->execute();

    // 3. Insere o registro na tabela de chamadas da TV
    $sql_tv = "INSERT INTO chamadas_tv (nome_paciente, numero_consultorio) VALUES (?, ?)";
    $stmt_tv = $conexao->prepare($sql_tv);
    $stmt_tv->bind_param("ss", $nomePaciente, $numConsultorio);
    $stmt_tv->execute();

    $conexao->commit();
    echo json_encode(['success' => true, 'message' => $nomePaciente . ' foi chamado para o ' . $numConsultorio]);

} catch (Exception $e) {
    $conexao->rollback();
    echo json_encode(['success' => false, 'message' => 'Erro ao chamar paciente: ' . $e->getMessage()]);
}

$conexao->close();
?>